@extends('admin.layouts.app')

@section('content')
    <div class="space-y-4">
        <h2 class="text-xl font-semibold">{{ trans( 'main.settings' ) }} — {{ trans( 'main.apps.services' ) }}</h2>
        <div class="text-sm text-gray-400">{{ settings( 'server_name' ) }}</div>

        <div class="dark-card p-4">
            <form action="{{ url( 'admin/services/settings' ) }}" method="post" class="space-y-6">
                {!! csrf_field() !!}

                <div>
                    <h4 class="font-semibold">{{ trans( 'services.teleport.title' ) }}</h4>
                </div>

                <div class="grid grid-cols-12 gap-4">
                    <div class="col-span-6">
                        <label class="block text-sm text-gray-300">{{ trans( 'services.fields.world_tag' ) }}</label>
                        <input name="teleport_world_tag" type="number" min="1" step="1" value="{{ old('teleport_world_tag', settings( 'teleport_world_tag' )) }}" class="mt-1 block w-48 bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                        @if($errors->has('teleport_world_tag'))
                            <div class="text-red-500 text-sm mt-1">{{ $errors->first('teleport_world_tag') }}</div>
                        @endif
                    </div>

                    <div class="col-span-2">
                        <label class="block text-sm text-gray-300">{{ trans( 'services.fields.x' ) }}</label>
                        <input name="teleport_x" type="number" min="1" step="1" value="{{ old('teleport_x', settings( 'teleport_x' )) }}" class="mt-1 block w-32 bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                        @if($errors->has('teleport_x'))
                            <div class="text-red-500 text-sm mt-1">{{ $errors->first('teleport_x') }}</div>
                        @endif
                    </div>

                    <div class="col-span-2">
                        <label class="block text-sm text-gray-300">{{ trans( 'services.fields.y' ) }}</label>
                        <input name="teleport_y" type="number" min="1" step="1" value="{{ old('teleport_y', settings( 'teleport_y' )) }}" class="mt-1 block w-32 bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                        @if($errors->has('teleport_y'))
                            <div class="text-red-500 text-sm mt-1">{{ $errors->first('teleport_y') }}</div>
                        @endif
                    </div>

                    <div class="col-span-2">
                        <label class="block text-sm text-gray-300">{{ trans( 'services.fields.z' ) }}</label>
                        <input name="teleport_z" type="number" min="1" step="1" value="{{ old('teleport_z', settings( 'teleport_z' )) }}" class="mt-1 block w-32 bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                        @if($errors->has('teleport_z'))
                            <div class="text-red-500 text-sm mt-1">{{ $errors->first('teleport_z') }}</div>
                        @endif
                    </div>
                </div>

                <div>
                    <h4 class="font-semibold">{{ trans( 'services.level_up.title' ) }}</h4>
                </div>

                <div class="grid grid-cols-12 gap-4">
                    <div class="col-span-4">
                        <label class="block text-sm text-gray-300">{{ trans( 'services.fields.cap' ) }}</label>
                        <input name="level_cap" type="number" min="1" step="1" value="{{ old('level_cap', settings( 'level_up_cap' )) }}" class="mt-1 block w-48 bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                        @if($errors->has('level_cap'))
                            <div class="text-red-500 text-sm mt-1">{{ $errors->first('level_cap') }}</div>
                        @endif
                    </div>
                </div>

                <div class="flex justify-end pt-4">
                    <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'main.save_settings' ) }}</button>
                </div>
            </form>
        </div>
    </div>

@endsection
