@extends('admin.layouts.app')

@section('content')
    <div class="flex items-center justify-between mb-4">
        <div>
            <h2 class="text-xl font-semibold">{{ trans('services.edit') }}</h2>
            <div class="text-sm text-gray-400">Table: <span class="font-mono">pweb_services</span> — <span class="font-medium">{{ $services->count() }}</span> rows</div>
        </div>
    </div>

    <form method="POST" action="{{ url('admin/services') }}">
        {!! csrf_field() !!}
        <div class="dark-card p-4 space-y-4">
            <div class="grid grid-cols-12 gap-4 px-2 py-2 text-sm text-gray-400 border-b border-gray-800">
                <div class="col-span-6 font-medium">{{ trans('services.name') }}</div>
                <div class="col-span-2 text-center font-medium">{{ trans('services.enabled') }}</div>
                <div class="col-span-4 text-right font-medium">{{ trans('services.price') }}</div>
            </div>
            @foreach($services as $service)
                <div class="grid grid-cols-12 gap-4 items-center border-b border-gray-800 py-4 px-2">
                    <div class="col-span-6 flex items-center space-x-4">
                        @if(!empty($service->icon))
                            <div class="w-10 h-10 bg-gray-800 rounded flex items-center justify-center text-indigo-400">
                                <i class="fas fa-{{ $service->icon }}"></i>
                            </div>
                        @endif
                        <div>
                            <div class="text-lg font-semibold">{{ $service->name ?: ucwords(str_replace('_', ' ', $service->key)) }}</div>
                            <div class="text-sm text-gray-400">{{ $service->description ?: (Lang::has('services.desc.' . $service->key) ? trans('services.desc.' . $service->key) : '') }}</div>
                        </div>
                    </div>
                    <div class="col-span-2 text-center">
                        <label class="flex items-center justify-center space-x-2">
                            <input type="checkbox" name="{{ $service->key }}_enabled" value="1" {{ $service->enabled ? 'checked' : '' }}>
                        </label>
                    </div>
                    <div class="col-span-4 text-right">
                        <input type="number" name="{{ $service->key }}_price" value="{{ old($service->key . '_price', $service->price) }}" class="w-36 bg-gray-800 border border-gray-700 text-gray-200 rounded-md px-3 py-2 inline-block" step="1">
                    </div>
                </div>
            @endforeach

            <div class="flex justify-end pt-4">
                <button type="submit" class="px-4 py-2 bg-green-600 hover:bg-green-500 text-white rounded">{{ trans('main.save') }}</button>
            </div>
        </div>
    </form>

@endsection
