@extends('admin.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto w-full">
    <div class="flex items-center justify-between mb-6">
        <div>
            <h1 class="text-2xl font-semibold text-gray-100">{{ trans('shop.create.title') }}</h1>
            <p class="text-gray-400 mt-1">{{ trans('shop.create.description', []) }}</p>
        </div>
        <a href="{{ url('admin/shop') }}" class="btn-secondary inline-flex items-center">
            <i class="fas fa-arrow-left mr-2"></i>{{ trans('common.back') }}
        </a>
    </div>

    <div class="bg-gray-800 rounded-lg shadow p-6">
        {{-- Use existing $item if provided, otherwise create a new model for the form binding --}}
        <?php
            // Determine form context from $item (provided on edit) or default to create
            $isEdit = isset($item) && $item instanceof \App\ShopItem;
            $formUrl = $isEdit ? url('admin/shop/'.$item->id) : url('admin/shop');
            $formMethod = $isEdit ? 'PUT' : 'POST';
            $submitButtonText = isset($submitButtonText) ? $submitButtonText : ($isEdit ? trans('shop.edit.submit') : trans('shop.create.submit'));
        ?>

        <?php if ($isEdit): ?>
            <?php echo Form::model($item, ['url' => $formUrl, 'method' => $formMethod]); ?>
                @include('admin.shop.form', ['submitButtonText' => $submitButtonText])
            <?php echo Form::close(); ?>
        <?php else: ?>
            <?php echo Form::open(['url' => $formUrl, 'method' => $formMethod]); ?>
                @include('admin.shop.form', ['submitButtonText' => $submitButtonText])
            <?php echo Form::close(); ?>
        <?php endif; ?>

    </div>
</div>
@endsection
