<div class="space-y-6">
    <!-- Item Name -->
    <div>
        <label for="name" class="block text-sm font-medium text-gray-300 mb-2">
            {{ trans('shop.fields.name') }} <span class="text-red-400">*</span>
        </label>
        {!! Form::text('name', NULL, ['class' => 'w-full', 'id' => 'name', 'placeholder' => 'Enter item name...', 'required' => true]) !!}
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Price -->
        <div>
            <label for="price" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.price') }} <span class="text-red-400">*</span>
            </label>
            <input type="number" name="price" id="price" class="w-full" placeholder="0" min="0" required value="{{ old('price', isset($item) ? $item->price : '') }}">
        </div>

        <!-- Item ID -->
        <div>
            <label for="item_id" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.item_id') }} <span class="text-red-400">*</span>
            </label>
            <input type="number" name="item_id" id="item_id" class="w-full" placeholder="0" min="0" required value="{{ old('item_id', isset($item) ? $item->item_id : '') }}">
        </div>
    </div>

    <!-- Octet -->
    <div>
        <label for="octet" class="block text-sm font-medium text-gray-300 mb-2">
            {{ trans('shop.fields.octet') }} <span class="text-red-400">*</span>
        </label>
        {!! Form::text('octet', NULL, ['class' => 'w-full', 'id' => 'octet', 'placeholder' => 'Enter octet data...', 'required' => true]) !!}
        <p class="mt-1 text-sm text-gray-400">Hexadecimal representation of the item data.</p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Mask -->
        <div>
            <label for="mask" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.mask') }} <span class="text-red-400">*</span>
            </label>
            {!! Form::select('mask', $masks, NULL, ['class' => 'w-full', 'id' => 'mask', 'required' => true]) !!}
        </div>

        <!-- Count -->
        <div>
            <label for="count" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.count') }} <span class="text-red-400">*</span>
            </label>
            <input type="number" name="count" id="count" class="w-full" placeholder="1" min="1" required value="{{ old('count', isset($item) ? $item->count : '') }}">
        </div>

        <!-- Max Count -->
        <div>
            <label for="max_count" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.max_count') }} <span class="text-red-400">*</span>
            </label>
            <input type="number" name="max_count" id="max_count" class="w-full" placeholder="1" min="1" required value="{{ old('max_count', isset($item) ? $item->max_count : '') }}">
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Protection Type -->
        <div>
            <label for="protection_type" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.protection_type') }}
            </label>
            <input type="number" name="protection_type" id="protection_type" class="w-full" placeholder="0" min="0" value="{{ old('protection_type', isset($item) ? $item->protection_type : '') }}">
        </div>

        <!-- Expire Date -->
        <div>
            <label for="expire_date" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.expire_date') }}
            </label>
            <input type="number" name="expire_date" id="expire_date" class="w-full" placeholder="0" min="0" value="{{ old('expire_date', isset($item) ? $item->expire_date : '') }}">
        </div>

        <!-- Discount -->
        <div>
            <label for="discount" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.discount') }}
            </label>
            <input type="number" name="discount" id="discount" class="w-full" placeholder="0" min="0" max="100" value="{{ old('discount', isset($item) ? $item->discount : '') }}">
        </div>
    </div>

    <!-- Shareable -->
    <div>
        <label class="block text-sm font-medium text-gray-300 mb-3">
            {{ trans('shop.fields.shareable.title') }}
        </label>
        <div class="flex space-x-6">
            <label class="flex items-center cursor-pointer">
                {!! Form::radio('shareable', 1, NULL, ['id' => 'yes', 'class' => 'mr-2']) !!}
                <span class="text-gray-300">{{ trans('shop.fields.shareable.yes') }}</span>
            </label>
            <label class="flex items-center cursor-pointer">
                {!! Form::radio('shareable', 0, NULL, ['id' => 'no', 'class' => 'mr-2']) !!}
                <span class="text-gray-300">{{ trans('shop.fields.shareable.no') }}</span>
            </label>
        </div>
    </div>

    <!-- Description -->
    <div>
        <label for="description" class="block text-sm font-medium text-gray-300 mb-2">
            {{ trans('shop.fields.description') }}
        </label>
        {!! Form::textarea('description', NULL, ['id' => 'summernote', 'class' => 'w-full', 'rows' => '6', 'placeholder' => 'Enter item description...']) !!}
    </div>
</div>

<!-- Form Actions -->
<?php $submitButtonText = isset($submitButtonText) ? $submitButtonText : trans('shop.create.submit'); ?>
<div class="flex justify-end pt-6 space-x-3" style="border-top: 1px solid #374151;">
    <a href="{{ url('admin/shop') }}" class="btn-secondary inline-flex items-center">
        <i class="fas fa-times mr-2"></i>Cancel
    </a>
    {!! Form::submit($submitButtonText, ['id' => 'form_submit', 'class' => 'btn-primary inline-flex items-center']) !!}
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
<script>
$(document).ready(function() {
    $('#summernote').summernote({
        height: 300,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'italic', 'underline', 'clear']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link', 'picture']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ],
        callbacks: {
            onInit: function() {
                // Apply dark theme to summernote
                $('.note-editor').css({
                    'background-color': '#1a1f2e',
                    'border': '1px solid #374151',
                    'border-radius': '8px'
                });
                $('.note-toolbar').css({
                    'background-color': '#252a3a',
                    'border-bottom': '1px solid #374151'
                });
                $('.note-editing-area .note-editable').css({
                    'background-color': '#1a1f2e',
                    'color': '#e2e8f0'
                });
            }
        }
    });

    $('#form_submit').click(function () {
        $('input[name="description"]').val($('#summernote').summernote('code'));
    });
});
</script>
@endpush
