@extends('admin.layouts.app')

@section('content')
<div class="space-y-4">
    <div class="flex items-center justify-between">
        <h2 class="text-lg font-semibold">{{ trans('shop.index') }}</h2>
        <a href="{{ url('admin/shop/create') }}" class="btn btn-primary">{{ trans('shop.add_button') }}</a>
    </div>

    <div class="dark-card overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-700">
            <thead class="bg-gray-800">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">{{ trans('main.id') ?? 'ID' }}</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">{{ trans('shop.fields.name') }}</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">{{ trans('shop.fields.price') }}</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">{{ trans('shop.fields.count') ?? 'Stock' }}</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">{{ trans('main.actions') }}</th>
                </tr>
            </thead>
            <tbody class="bg-transparent divide-y divide-gray-700">
                <?php
                    // Controller should provide $items; fall back to an empty collection to avoid errors
                    $items = isset($items) ? $items : collect([]);
                ?>

                @forelse($items as $item)
                    <tr>
                        <td class="px-6 py-4 text-sm text-gray-300">{{ $item->id }}</td>
                        <td class="px-6 py-4 text-sm text-white">{{ $item->name }}</td>
                        <td class="px-6 py-4 text-sm text-gray-300">{{ $item->price }}</td>
                        <td class="px-6 py-4 text-sm text-gray-300">{{ $item->stock ?? '-' }}</td>
                        <td class="px-6 py-4 text-sm text-gray-300">
                            <div class="flex items-center space-x-2">
                                <a href="{{ url('admin/shop/' . $item->id . '/edit') }}" class="px-3 py-1 rounded bg-gray-800 text-sm text-white">{{ trans('main.edit') }}</a>
                                <form method="POST" action="{{ url('admin/shop/' . $item->id) }}" x-data @submit.prevent="if(confirm('Delete this item?')) $event.target.submit()">
                                    {{ method_field('DELETE') }}
                                    {{ csrf_field() }}
                                    <button type="submit" class="px-3 py-1 rounded bg-red-600 text-sm text-white">{{ trans('main.remove') }}</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-10 text-center text-sm text-gray-400">
                            {{ trans('shop.no_items') }}. <a href="{{ url('admin/shop/create') }}" class="text-indigo-300 underline">{{ trans('shop.add_button') }}</a>.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{-- Pagination placeholder: controller may supply links() --}}
    @if(isset($items) && method_exists($items, 'links'))
        <div class="mt-4">
            {{ $items->links() }}
        </div>
    @endif

    <p class="text-xs text-gray-400">Original views are backed up at <code>resources/views/admin-backup-20251009-074355</code></p>
</div>
@endsection

