@extends('admin.layouts.app')

@section('content')
<div class="max-w-3xl mx-auto">
    <div class="flex items-center justify-between mb-6">
        <div>
            <h1 class="text-2xl font-semibold text-gray-100">{{ trans('main.settings') }}</h1>
            <p class="text-gray-400 mt-1">{{ trans('main.apps.shop') }}</p>
        </div>
        <a href="{{ url('admin/shop') }}" class="btn-secondary inline-flex items-center">
            <i class="fas fa-arrow-left mr-2"></i>{{ trans('common.back') }}
        </a>
    </div>

    <div class="bg-gray-800 rounded-lg shadow p-6">
        {!! Form::open(['url' => url('admin/shop/settings'), 'method' => 'POST']) !!}

        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-300 mb-2">{{ trans('shop.settings.items_per_page') }}</label>
            <input type="number" name="items_per_page" class="w-32" min="1" value="{{ old('items_per_page', settings('shop_items_per_page', 10)) }}">
            <p class="text-xs text-gray-400 mt-2">{{ trans('shop.settings.items_per_page_help') }}</p>
        </div>

        <div class="flex justify-end">
            <button type="submit" class="btn-primary inline-flex items-center">
                <i class="fas fa-save mr-2"></i>Save
            </button>
        </div>

        {!! Form::close() !!}
    </div>
</div>
@endsection
