@extends('admin.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto space-y-6">
    <form action="{{ url('admin/system/apps') }}" method="post" class="space-y-6">
        {!! csrf_field() !!}

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            @foreach($apps as $app)
                <div class="dark-card p-4 flex items-center justify-between">
                    <div>
                        <div class="text-lg font-semibold text-white">{{ is_array(trans('main.apps.' . $app->key)) ? ($app->name ?? ucfirst($app->key)) : trans('main.apps.' . $app->key) }}</div>
                        <div class="text-sm text-gray-400">{{ is_array(trans('main.apps.' . $app->key . '_desc')) ? ($app->description ?? '') : trans('main.apps.' . $app->key . '_desc') }}</div>
                    </div>
                    <div class="flex items-center space-x-3">
                        <label for="{{ $app->key }}_enabled" class="text-sm text-gray-300">{{ trans('system.enabled') }}</label>
                        <input id="{{ $app->key }}_enabled" name="{{ $app->key }}_enabled" type="checkbox" class="h-5 w-5 text-indigo-600 rounded" {{ $app->enabled ? 'checked' : '' }}>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="flex justify-end">
            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">
                <i class="fas fa-save mr-2"></i> {{ trans('main.save_settings') }}
            </button>
        </div>
    </form>
</div>
@endsection