@extends('admin.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="dark-card">
        <div class="px-6 py-4 flex items-center justify-between border-b border-gray-700">
            <div>
                <h1 class="text-2xl font-bold text-white">{{ trans('system.server_settings') }}</h1>
                <p class="text-gray-400 mt-1">{{ trans('system.server_settings_desc') }}</p>
            </div>
            <div class="w-12 h-12 bg-gradient-to-br from-indigo-600 to-purple-600 rounded-lg flex items-center justify-center">
                <i class="fas fa-cogs text-white"></i>
            </div>
        </div>

        <div class="p-6">
            <form action="{{ url('admin/system/settings') }}" method="post" class="space-y-6">
                {!! csrf_field() !!}

                <div class="grid grid-cols-1 gap-6">
                    <div>
                        <label for="server_name" class="block text-sm font-medium text-gray-300 mb-2">{{ trans('system.server_name') }}</label>
                        <input name="server_name" id="server_name" type="text" class="w-full" value="{{ settings('server_name') }}" required>
                    </div>

                    <div>
                        <label for="currency_name" class="block text-sm font-medium text-gray-300 mb-2">{{ trans('system.currency_name') }}</label>
                        <input name="currency_name" id="currency_name" type="text" class="w-full" value="{{ settings('currency_name') }}" required>
                    </div>

                    <div>
                        <label for="server_ip" class="block text-sm font-medium text-gray-300 mb-2">{{ trans('system.server_ip') }}</label>
                        <input name="server_ip" id="server_ip" type="text" class="w-full" value="{{ settings('server_ip') }}" required>
                        <p class="mt-1 text-sm text-gray-400">{{ trans('system.server_ip_desc') }}</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="server_version" class="block text-sm font-medium text-gray-300 mb-2">{{ trans('system.server_version') }}</label>
                        <select name="server_version" id="version" class="w-full">
                            @foreach(['07','63','69','70','80','85','88','101','145','156'] as $v)
                                <option value="{{ $v }}" {{ settings('server_version') == $v ? 'selected' : '' }}>v{{ $v }}</option>
                            @endforeach
                        </select>
                        <p class="mt-1 text-sm text-gray-400">{{ trans('system.server_version_desc') }}</p>
                    </div>

                    <div>
                        <label for="encryption_type" class="block text-sm font-medium text-gray-300 mb-2">{{ trans('system.encrypt_type') }}</label>
                        <select name="encryption_type" id="encryption_type" class="w-full">
                            <option value="md5" {{ settings('encryption_type') == 'md5' ? 'selected' : '' }}>{{ trans('system.encrypt.md5') }}</option>
                            <option value="base64" {{ settings('encryption_type') == 'base64' ? 'selected' : '' }}>{{ trans('system.encrypt.base64') }}</option>
                        </select>
                        <p class="mt-1 text-sm text-gray-400">{{ trans('system.encrypt_type_desc') }}</p>
                    </div>
                </div>

                <!-- Scheduled Broadcasts Settings -->
                <div class="border-t border-gray-700 pt-6">
                    <h3 class="text-lg font-semibold text-white mb-4">{{ trans('system.broadcast_settings') }}</h3>
                    <div class="space-y-4">
                        <div class="flex items-center">
                            <input type="hidden" name="scheduled_broadcasts_enabled" value="0">
                            <input type="checkbox"
                                   id="scheduled_broadcasts_enabled"
                                   name="scheduled_broadcasts_enabled"
                                   value="1"
                                   {{ settings('scheduled_broadcasts_enabled', true) ? 'checked' : '' }}
                                   class="rounded border-gray-700 bg-gray-800 text-indigo-600 focus:ring-indigo-500 focus:ring-2">
                            <label for="scheduled_broadcasts_enabled" class="ml-3 text-sm font-medium text-gray-300">
                                {{ trans('system.scheduled_broadcasts_enabled') }}
                            </label>
                        </div>
                        <p class="text-sm text-gray-400">{{ trans('system.scheduled_broadcasts_enabled_desc') }}</p>
                    </div>
                </div>

                <div class="flex justify-end pt-6 border-t border-gray-700">
                    <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">
                        <i class="fas fa-save mr-2"></i> {{ trans('main.save_settings') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection