<div class="space-y-4">
    <div class="flex items-center">
        {!! Form::label( 'double_rewards', trans( 'vote.fields.double_rewards' ), ['class' => 'block text-sm text-gray-400 mr-4'] ) !!}
        {!! Form::checkbox( 'double_rewards', 1, NULL, ['id' => 'double_rewards'] ) !!}
    </div>

    <div>
        {!! Form::label( 'name', trans( 'vote.fields.name' ), ['class' => 'block text-sm text-gray-400'] ) !!}
        {!! Form::text( 'name', NULL, ['class' => 'w-full bg-gray-800 border border-gray-700 text-gray-200 rounded-md px-3 py-2'] ) !!}
    </div>

    <div>
        {!! Form::label( 'link', trans( 'vote.fields.link' ), ['class' => 'block text-sm text-gray-400'] ) !!}
        {!! Form::input( 'url', 'link', NULL, ['class' => 'w-full bg-gray-800 border border-gray-700 text-gray-200 rounded-md px-3 py-2'] ) !!}
    </div>

    <div>
        <label class="block text-sm text-gray-400">{{ trans('vote.fields.type.title') }}</label>
        <div class="flex space-x-4 mt-2">
            <label class="flex items-center"><input type="radio" name="type" value="cubi"> {{ trans('vote.fields.type.cubi') }}</label>
            <label class="flex items-center"><input type="radio" name="type" value="virtual"> {{ trans('vote.fields.type.virtual') }}</label>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
            {!! Form::label( 'reward_amount', trans( 'vote.fields.reward' ), ['class' => 'block text-sm text-gray-400'] ) !!}
            <input type="number" name="reward_amount" class="w-full bg-gray-800 border border-gray-700 text-gray-200 rounded-md px-3 py-2" value="{{ old('reward_amount', isset($site) ? $site->reward_amount : '') }}">
        </div>
        <div>
            {!! Form::label( 'hour_limit', trans( 'vote.fields.limit' ), ['class' => 'block text-sm text-gray-400'] ) !!}
            <input type="number" name="hour_limit" class="w-full bg-gray-800 border border-gray-700 text-gray-200 rounded-md px-3 py-2" value="{{ old('hour_limit', isset($site) ? $site->hour_limit : '') }}">
        </div>
    </div>

    <div class="flex justify-end">
        {!! Form::submit( $submitButtonText, ['id' => 'form_submit', 'class' => 'px-4 py-2 bg-green-600 text-white rounded-md'] ) !!}
    </div>
</div>
