@extends('admin.layouts.app')

@section( 'content' )
    @if ( setupTasks() )
        <div class="dark-card mb-4">
            <p>{{ trans( 'main.cron.info' ) }}</p>
            <p>{{ trans( 'main.cron.job' ) }}</p>
        </div>
    @endif

    <div class="flex items-center justify-between mb-4">
        <h2 class="text-xl font-semibold">{{ trans('vote.index') }}</h2>
        <a href="{{ url('admin/vote/create') }}" class="px-4 py-2 bg-indigo-600 hover:bg-indigo-500 text-white rounded">
            <i class="fas fa-plus mr-2"></i>{{ trans('vote.add_button') }}
        </a>
    </div>

    <div class="dark-card">
        @if($sites->isEmpty())
            <div class="p-6 text-center">
                <p class="text-gray-400 mb-4">{{ trans('vote.no_sites', [], null) ?: 'No vote sites have been configured yet.' }}</p>
                <a href="{{ url('admin/vote/create') }}" class="px-4 py-2 bg-green-600 hover:bg-green-500 text-white rounded">{{ trans('vote.add_button') }}</a>
            </div>
        @else
            <div class="space-y-4 p-4">
                @foreach( $sites as $site )
                    <div x-data class="bg-gray-900 border border-gray-800 rounded-lg p-4">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-lg font-semibold">{{ $site->name }} @if($site->double_rewards) <span class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-indigo-600 text-white">{{ trans('vote.double_rewards') }}</span> @endif</h3>
                                <p class="text-sm text-gray-400">{{ $site->link }}</p>
                            </div>
                            <div class="flex items-center space-x-2">
                                <a href="{{ url('admin/vote/'.$site->id.'/edit') }}" class="px-3 py-1 text-sm bg-yellow-600 hover:bg-yellow-500 rounded text-white">{{ trans('main.edit') }}</a>
                                <button @click="if(confirm('{{ addslashes(trans('main.remove')) }}?')) { let el = $event.target.closest('[x-data]'); fetch('{{ url('admin/vote/'.$site->id) }}', { method: 'DELETE', headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept': 'application/json' } }).then(r => { if(r.ok) el.remove(); }); }" class="px-3 py-1 text-sm bg-red-600 hover:bg-red-500 rounded text-white">{{ trans('main.remove') }}</button>
                            </div>
                        </div>

                        <div class="mt-4 border-t border-gray-800 pt-4 grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <dt class="text-sm text-gray-400">{{ trans( 'vote.fields.link' ) }}</dt>
                                <dd class="mt-1 text-sm text-gray-200">{{ $site->link }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm text-gray-400">{{ trans( 'vote.fields.limit' ) }}</dt>
                                <dd class="mt-1 text-sm text-gray-200">{{ $site->hour_limit }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm text-gray-400">{{ trans( 'vote.fields.reward' ) }}</dt>
                                <dd class="mt-1 text-sm text-gray-200">{{ $site->reward_amount }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm text-gray-400">{{ trans( 'vote.fields.type.title' ) }}</dt>
                                <dd class="mt-1 text-sm text-gray-200">{{ $site->type }}</dd>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="mt-6 text-center p-4">
                {!! $sites->render() !!}
            </div>
        @endif
    </div>
@endsection
