@extends('admin.layouts.app')

@section( 'content' )
    <div class="dark-card">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead>
                    <tr class="bg-gray-900">
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400">{{ trans( 'voucher.table.code' ) }}</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400">{{ trans( 'voucher.table.name' ) }}</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400">{{ trans( 'voucher.table.redeemed' ) }}</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-400">{{ trans( 'voucher.table.actions' ) }}</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-800">
                    @foreach( $vouchers as $voucher )
                        <tr x-data class="hover:bg-gray-850">
                            <td class="px-6 py-4 text-sm text-gray-200" data-code>{{ $voucher->code }}</td>
                            <td class="px-6 py-4 text-sm text-gray-200">{{ $voucher->item_name }}</td>
                            <td class="px-6 py-4 text-sm text-gray-200">{{ $voucher->times_redeemed }}</td>
                            <td class="px-6 py-4 text-sm text-right">
                                <div class="inline-flex items-center space-x-2 justify-end">
                                    <a href="{{ url('admin/voucher/'.$voucher->code.'/edit') }}" class="px-3 py-1 text-sm bg-yellow-600 hover:bg-yellow-500 rounded text-white">{{ trans('main.edit') }}</a>
                                    <button @click="if(confirm('{{ addslashes(trans('main.remove')) }}?')) { let row = $event.target.closest('tr'); fetch('{{ url('admin/voucher/'.$voucher->code) }}', { method: 'DELETE', headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept': 'application/json' } }).then(r => { if(r.ok) row.remove(); }); }" class="px-3 py-1 text-sm bg-red-600 hover:bg-red-500 rounded text-white">{{ trans('main.remove') }}</button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-6 text-center">
            {!! $vouchers->render() !!}
        </div>
    </div>
@endsection

@section('footer')
    @parent
    {{-- Deletion handled inline via Alpine/Fetch; no extra scripts required --}}
@endsection
