<div class="dark-card">
    <div class="px-6 py-4 flex items-center justify-between" style="border-bottom: 1px solid #374151;">
        <div>
            <h1 class="text-2xl font-bold text-white">
                {{ isset($article) ? trans('wiki.edit_article') : trans('wiki.create_article') }}
            </h1>
            <p class="text-gray-400 mt-1">
                {{ isset($article) ? trans('wiki.update_article_desc') : trans('wiki.create_article_desc') }}
            </p>
        </div>
        <div>
            <a href="{{ url('admin/wiki') }}" class="btn-secondary inline-flex items-center">
                <i class="fas fa-arrow-left mr-2"></i>{{ trans('main.back') }}
            </a>
        </div>
    </div>
    <div class="p-6">
        <form method="post" action="{{ isset($article) ? url('admin/wiki/edit/' . $article->id) : url('admin/wiki/create') }}" class="space-y-6">
            {!! csrf_field() !!}
            <!-- Title -->
            <div>
                <label for="title" class="block text-sm font-medium text-gray-300 mb-2">
                    {{ trans('wiki.article_title') }} <span class="text-red-400">*</span>
                </label>
                <input type="text" 
                       id="title"
                       name="title" 
                       value="{{ old('title', isset($article) ? $article->title : '') }}" 
                       class="w-full"
                       placeholder="Enter article title..."
                       required>
                @if($errors->has('title'))
                    <p class="mt-1 text-sm text-red-400">{{ $errors->first('title') }}</p>
                @endif
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Category -->
                <div>
                    <label for="category" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('wiki.article_category') }} <span class="text-red-400">*</span>
                    </label>
                    <select id="category" 
                            name="category" 
                            class="w-full"
                            required>
                        @foreach($categories as $key => $name)
                            <option value="{{ $key }}" 
                                    {{ old('category', isset($article) ? $article->category : '') == $key ? 'selected' : '' }}>
                                {{ $name }}
                            </option>
                        @endforeach
                    </select>
                    @if($errors->has('category'))
                        <p class="mt-1 text-sm text-red-400">{{ $errors->first('category') }}</p>
                    @endif
                </div>

                <!-- Status -->
                <div>
                    <label for="status" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('wiki.article_status') }} <span class="text-red-400">*</span>
                    </label>
                    <select id="status" 
                            name="status" 
                            class="w-full"
                            required>
                        <option value="published" 
                                {{ old('status', isset($article) ? $article->status : 'published') == 'published' ? 'selected' : '' }}>
                            {{ trans('wiki.status_published') }}
                        </option>
                        <option value="draft" 
                                {{ old('status', isset($article) ? $article->status : '') == 'draft' ? 'selected' : '' }}>
                            {{ trans('wiki.status_draft') }}
                        </option>
                    </select>
                    @if($errors->has('status'))
                        <p class="mt-1 text-sm text-red-400">{{ $errors->first('status') }}</p>
                    @endif
                </div>
            </div>

            <!-- Excerpt -->
            <div>
                <label for="excerpt" class="block text-sm font-medium text-gray-300 mb-2">
                    {{ trans('wiki.article_excerpt') }}
                </label>
                <textarea id="excerpt"
                          name="excerpt" 
                          rows="3" 
                          class="w-full"
                          placeholder="Optional short description of the article...">{{ old('excerpt', isset($article) ? $article->excerpt : '') }}</textarea>
                @if($errors->has('excerpt'))
                    <p class="mt-1 text-sm text-red-400">{{ $errors->first('excerpt') }}</p>
                @endif
                <p class="mt-1 text-sm text-gray-400">Leave empty to auto-generate from content.</p>
            </div>

            <!-- Content -->
            <div>
                <label for="content" class="block text-sm font-medium text-gray-300 mb-2">
                    {{ trans('wiki.article_content') }} <span class="text-red-400">*</span>
                </label>
                <textarea id="content" 
                          name="content" 
                          rows="30" 
                          class="w-full"
                          required>{{ old('content', isset($article) ? $article->content : '') }}</textarea>
                @if($errors->has('content'))
                    <p class="mt-1 text-sm text-red-400">{{ $errors->first('content') }}</p>
                @endif
            </div>

            <!-- Form Actions -->
            <div class="flex items-center justify-between pt-6" style="border-top: 1px solid #374151;">
                <div class="flex space-x-3">
                    <button type="submit" class="btn-primary inline-flex items-center">
                        <i class="fas fa-save mr-2"></i>
                        {{ isset($article) ? trans('wiki.update_article') : trans('wiki.save_article') }}
                    </button>
                    <a href="{{ url('admin/wiki') }}" class="btn-secondary inline-flex items-center">
                        <i class="fas fa-times mr-2"></i>{{ trans('main.cancel') }}
                    </a>
                </div>
                
                @if(isset($article))
                    <a href="{{ url('wiki/' . $article->slug) }}" 
                       target="_blank"
                       class="btn-primary inline-flex items-center"
                       style="background: linear-gradient(135deg, #3b82f6, #1d4ed8) !important;">
                        <i class="fas fa-eye mr-2"></i>{{ trans('main.preview') }}
                    </a>
                @endif
            </div>
        </form>
    </div>
</div>

<style>
    /* Increase CKEditor editable area height */
    .ck-editor__editable[role="textbox"], .ck-editor__editable_inline {
        min-height: 600px;
    }
</style>

@push('scripts')
<script src="https://cdn.ckeditor.com/ckeditor5/35.4.0/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create(document.querySelector('#content'), {
            toolbar: [
                'heading', '|',
                'bold', 'italic', 'link', '|',
                'bulletedList', 'numberedList', '|',
                'outdent', 'indent', '|',
                'blockQuote', 'insertTable', '|',
                'undo', 'redo'
            ]
        })
        .catch(error => {
            console.error(error);
        });
</script>
@endpush
