@extends('front.layouts.app')

@section('content')
<div class="min-h-96 flex items-center justify-center">
    <div class="text-center">
        <div class="mb-8">
            <svg class="w-24 h-24 mx-auto text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
            </svg>
        </div>
        
        <h1 class="text-6xl font-bold text-red-500 mb-4">500</h1>
        <h2 class="text-2xl font-semibold text-dark-700 mb-4">{{ trans('main.500.title') }}</h2>
        <p class="text-dark-600 mb-8 max-w-md mx-auto">
            {{ trans('main.500.content') }}
        </p>
        
        <div class="space-x-4">
            <a href="{{ (Request::is('admin/*') ? 'admin' : '/') }}" class="btn btn-primary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                </svg>
                {{ trans('main.500.button') }}
            </a>
            <button onclick="history.back()" class="btn btn-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Go Back
            </button>
        </div>
    </div>
</div>
@endsection