@extends('front.layouts.app')

@section('content')
<div class="min-h-96 flex items-center justify-center">
    <div class="text-center">
        <div class="mb-8">
            <svg class="w-24 h-24 mx-auto text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
            </svg>
        </div>
        
        <h1 class="text-6xl font-bold text-amber-500 mb-4">503</h1>
        <h2 class="text-2xl font-semibold text-dark-700 mb-4">Service Unavailable</h2>
        <p class="text-dark-600 mb-8 max-w-md mx-auto">
            We're currently performing maintenance. We'll be right back!
        </p>
        
        <div class="animate-pulse">
            <div class="flex justify-center space-x-1">
                <div class="w-2 h-2 bg-primary-500 rounded-full animate-bounce"></div>
                <div class="w-2 h-2 bg-primary-500 rounded-full animate-bounce" style="animation-delay: 0.1s"></div>
                <div class="w-2 h-2 bg-primary-500 rounded-full animate-bounce" style="animation-delay: 0.2s"></div>
            </div>
        </div>
    </div>
</div>
@endsection
