@extends('front.layouts.app')

@section('content')
    <div class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60">
        <div class="p-6 border-b border-gray-700/40">
            <h2 class="text-xl font-bold text-white">{{ trans('main.acc_tabs.overview.title') }}</h2>
        </div>
        <div class="p-6">
            <div x-data="{ activeTab: 'overview' }" class="space-y-6">
                <!-- Tab Navigation -->
                <div class="flex flex-wrap border-b border-dark-200/50">
                    <button @click="activeTab = 'overview'" 
                            :class="activeTab === 'overview' ? 'border-primary-500 text-primary-400' : 'border-transparent text-dark-500 hover:text-dark-700 hover:border-dark-300'"
                            class="flex items-center gap-2 px-6 py-3 border-b-2 font-medium text-sm transition-all duration-200">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                        {{ trans('main.acc_tabs.overview.title') }}
                    </button>
                    <button @click="activeTab = 'email'" 
                            :class="activeTab === 'email' ? 'border-primary-500 text-primary-400' : 'border-transparent text-dark-500 hover:text-dark-700 hover:border-dark-300'"
                            class="flex items-center gap-2 px-6 py-3 border-b-2 font-medium text-sm transition-all duration-200">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        {{ trans('main.acc_tabs.email.title') }}
                    </button>
                    <button @click="activeTab = 'password'" 
                            :class="activeTab === 'password' ? 'border-primary-500 text-primary-400' : 'border-transparent text-dark-500 hover:text-dark-700 hover:border-dark-300'"
                            class="flex items-center gap-2 px-6 py-3 border-b-2 font-medium text-sm transition-all duration-200">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                        {{ trans('main.acc_tabs.password.title') }}
                    </button>
                </div>

                <!-- Tab Content -->
                <!-- Overview Tab -->
                <div x-show="activeTab === 'overview'" 
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-y-4"
                     x-transition:enter-end="opacity-100 transform translate-y-0"
                     class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                    
                    <!-- Account Information -->
                    <div class="space-y-6">
                        <h3 class="text-lg font-semibold text-dark-800 mb-4">{{ trans('main.account_information') }}</h3>
                        
                        <div class="space-y-4">
                            <div class="bg-dark-50 rounded-xl p-4 hover:bg-dark-100/50 transition-colors">
                                <label class="form-label">{{ trans('main.acc_tabs.overview.fields.name') }}</label>
                                <div class="text-dark-800 font-medium">{{ Auth::user()->name }}</div>
                            </div>
                            
                            <div class="bg-dark-50 rounded-xl p-4 hover:bg-dark-100/50 transition-colors">
                                <label class="form-label">{{ trans('main.acc_tabs.overview.fields.email') }}</label>
                                <div class="text-dark-800 font-medium">{{ Auth::user()->email }}</div>
                            </div>
                            
                            <div class="bg-dark-50 rounded-xl p-4 hover:bg-dark-100/50 transition-colors">
                                <label class="form-label">{{ trans('main.acc_tabs.overview.fields.password') }}</label>
                                <div class="text-dark-800 font-medium">••••••••</div>
                            </div>
                        </div>
                    </div>

                    <!-- Character List -->
                    <div class="space-y-6">
                        <h3 class="text-lg font-semibold text-dark-800 mb-4">{{ trans('main.char_list.title') }}</h3>
                        
                        <div class="space-y-3">
                            @if($api->online)
                                @php $roles = Auth::user()->roles() @endphp
                                @if(count($roles) > 0)
                                    @foreach($roles as $role)
                                        <div class="bg-dark-50 rounded-xl p-4 flex items-center justify-between hover:bg-dark-100/50 transition-all duration-200 hover:scale-[1.02]">
                                            <div class="flex items-center space-x-3">
                                                <div class="w-10 h-10 bg-gradient-to-br from-primary-500/20 to-purple-500/20 rounded-lg flex items-center justify-center">
                                                    <svg class="w-5 h-5 text-primary-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                                    </svg>
                                                </div>
                                                <div>
                                                    <div class="font-medium text-dark-800">{{ $role['name'] }}</div>
                                                    <div class="text-sm text-dark-500">{{ trans('main.char_list.id', ['n' => $role['id']]) }}</div>
                                                </div>
                                            </div>
                                            <span class="px-3 py-1 bg-primary-500/20 text-primary-600 rounded-full text-xs font-medium">
                                                Active
                                            </span>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="text-center py-8">
                                        <svg class="w-16 h-16 mx-auto text-dark-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                        </svg>
                                        <p class="text-dark-500">{{ trans('main.no_characters') }}</p>
                                    </div>
                                @endif
                            @else
                                <div class="text-center py-8">
                                    <svg class="w-16 h-16 mx-auto text-red-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                                    </svg>
                                    <p class="text-red-400">{{ trans('main.server_not_online') }}</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                <!-- Email Tab -->
                <div x-show="activeTab === 'email'" 
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-y-4"
                     x-transition:enter-end="opacity-100 transform translate-y-0"
                     class="max-w-md">
                    
                    <form action="{{ url('account/settings/email') }}" method="post" class="space-y-6">
                        {!! csrf_field() !!}
                        
                        <div>
                            <label for="email_address" class="form-label">{{ trans('main.acc_tabs.email.fields.email') }}</label>
                            <input name="email_address" 
                                   type="email" 
                                   class="form-input" 
                                   id="email_address"
                                   placeholder="Enter new email address">
                        </div>
                        
                        <button type="submit" class="btn btn-primary">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            {{ trans('main.save') }}
                        </button>
                    </form>
                </div>
                <!-- Password Tab -->
                <div x-show="activeTab === 'password'" 
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-y-4"
                     x-transition:enter-end="opacity-100 transform translate-y-0"
                     class="max-w-md">
                    
                    <form action="{{ url('account/settings/password') }}" method="post" class="space-y-6">
                        {!! csrf_field() !!}
                        
                        <div>
                            <label for="current_password" class="form-label">{{ trans('main.acc_tabs.password.fields.current') }}</label>
                            <input name="current_password" 
                                   type="password" 
                                   class="form-input" 
                                   id="current_password"
                                   placeholder="Enter current password">
                            <p class="mt-2 text-sm text-dark-500">{{ trans('main.acc_tabs.password.fields.current_desc') }}</p>
                        </div>
                        
                        <div>
                            <label for="new_password" class="form-label">{{ trans('main.acc_tabs.password.fields.new') }}</label>
                            <input name="new_password" 
                                   type="password" 
                                   class="form-input" 
                                   id="new_password"
                                   placeholder="Enter new password">
                        </div>
                        
                        <div>
                            <label for="new_password_confirmation" class="form-label">{{ trans('main.acc_tabs.password.fields.confirm') }}</label>
                            <input name="new_password_confirmation" 
                                   type="password" 
                                   class="form-input" 
                                   id="new_password_confirmation"
                                   placeholder="Confirm new password">
                        </div>
                        
                        <button type="submit" class="btn btn-primary">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            {{ trans('main.save') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection