<!DOCTYPE html>
<html lang="en" class="h-full dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ pagetitle()->get() }}</title>
    <meta name="description" content="">
    <meta name="author" content="">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Styles -->
    <link href="{{ asset('build/app.css') }}" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('favicon.ico') }}">
</head>
<body class="h-full bg-gradient-dark text-dark-800 antialiased">
    <div class="min-h-full flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8">
            <!-- Logo/Header -->
            <div class="text-center">
                <h2 class="text-3xl font-bold gradient-text">
                    {{ settings('server_name', 'Perfect World Panel') }}
                </h2>
                <p class="mt-2 text-sm text-dark-500">
                    Welcome back to your adventure
                </p>
            </div>

            <!-- Login/Register Forms Container -->
            <div x-data="{ showRegister: false }" class="space-y-6">
                
                <!-- Login Form -->
                <div x-show="!showRegister" 
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-x-4"
                     x-transition:enter-end="opacity-100 transform translate-x-0"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100 transform translate-x-0"
                     x-transition:leave-end="opacity-0 transform -translate-x-4"
                     class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60">
                    
                    <div class="p-6 border-b border-gray-700/40">
                        <h3 class="text-xl font-bold text-white">{{ trans('main.signin.title') }}</h3>
                    </div>
                    
                    <div class="p-6">
                        @if($errors->any())
                            <div class="alert alert-danger mb-6">
                                @foreach($errors->all() as $error)
                                    <p>{{ $error }}</p>
                                @endforeach
                            </div>
                        @endif

                        <form action="{{ url('auth/login') }}" method="post" class="space-y-6">
                            {!! csrf_field() !!}
                            
                            <div>
                                <label for="username" class="form-label">{{ trans('main.signin.username') }}</label>
                                <input id="username" 
                                       name="username" 
                                       type="text" 
                                       class="form-input" 
                                       placeholder="{{ trans('main.signin.username') }}"
                                       required>
                            </div>

                            <div>
                                <label for="password" class="form-label">{{ trans('main.signin.password') }}</label>
                                <input id="password" 
                                       name="password" 
                                       type="password" 
                                       class="form-input" 
                                       placeholder="{{ trans('main.signin.password') }}"
                                       required>
                            </div>

                            <!-- Math Captcha -->
                            <div>
                                <label for="captcha" class="form-label">Security Question</label>
                                <div class="bg-dark-50 rounded-lg p-4 mb-3">
                                    <div class="flex items-center justify-between">
                                        <span class="text-lg font-mono text-dark-800" id="math-question">
                                            {{ App\Http\Controllers\MathCaptchaController::generate() }}
                                        </span>
                                        <button type="button" onclick="refreshMathCaptcha()" class="text-primary-400 hover:text-primary-300 text-sm">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                                <input id="captcha" 
                                       name="captcha" 
                                       type="number" 
                                       class="form-input" 
                                       placeholder="Enter the answer"
                                       required>
                                <p class="text-xs text-dark-500 mt-1">Solve the math problem above</p>
                            </div>

                            <button type="submit" class="btn btn-primary btn-block btn-lg">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                                </svg>
                                {{ trans('main.signin.button') }}
                            </button>
                        </form>
                    </div>
                    
                    <div class="px-6 pb-6">
                        <div class="text-center">
                            <button @click="showRegister = true" 
                                    class="text-primary-400 hover:text-primary-300 text-sm font-medium transition-colors">
                                {{ trans('main.signin.create') }}
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Register Form -->
                <div x-show="showRegister" 
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-x-4"
                     x-transition:enter-end="opacity-100 transform translate-x-0"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100 transform translate-x-0"
                     x-transition:leave-end="opacity-0 transform -translate-x-4"
                     class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60">
                    
                    <div class="p-6 border-b border-gray-700/40">
                        <h3 class="text-xl font-bold text-white">{{ trans('main.signup.title') }}</h3>
                        <p class="text-sm text-gray-400 mt-1">{{ trans('main.signup.info') }}</p>
                    </div>
                    
                    <div class="p-6">
                        <form action="{{ url('auth/register') }}" method="post" class="space-y-6">
                            {!! csrf_field() !!}
                            
                            <div>
                                <label for="reg_email" class="form-label">{{ trans('main.signup.email') }}</label>
                                <input id="reg_email" 
                                       name="email" 
                                       type="email" 
                                       class="form-input" 
                                       placeholder="{{ trans('main.signup.email') }}"
                                       required>
                            </div>

                            <div>
                                <label for="reg_username" class="form-label">{{ trans('main.signup.username') }}</label>
                                <input id="reg_username" 
                                       name="name" 
                                       type="text" 
                                       class="form-input" 
                                       placeholder="{{ trans('main.signup.username') }}"
                                       required>
                            </div>

                            <div>
                                <label for="reg_password" class="form-label">{{ trans('main.signup.password') }}</label>
                                <input id="reg_password" 
                                       name="password" 
                                       type="password" 
                                       class="form-input" 
                                       placeholder="{{ trans('main.signup.password') }}"
                                       required>
                            </div>

                            <div>
                                <label for="reg_password_confirmation" class="form-label">{{ trans('main.signup.confirm') }}</label>
                                <input id="reg_password_confirmation" 
                                       name="password_confirmation" 
                                       type="password" 
                                       class="form-input" 
                                       placeholder="{{ trans('main.signup.confirm') }}"
                                       required>
                            </div>

                            <!-- Math Captcha for Registration -->
                            <div>
                                <label for="reg_captcha" class="form-label">Security Question</label>
                                <div class="bg-dark-50 rounded-lg p-4 mb-3">
                                    <div class="flex items-center justify-between">
                                        <span class="text-lg font-mono text-dark-800" id="reg-math-question">
                                            {{ App\Http\Controllers\MathCaptchaController::generateReg() }}
                                        </span>
                                        <button type="button" onclick="refreshRegMathCaptcha()" class="text-primary-400 hover:text-primary-300 text-sm">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                                <input id="reg_captcha" 
                                       name="captcha" 
                                       type="number" 
                                       class="form-input" 
                                       placeholder="Enter the answer"
                                       required>
                                <p class="text-xs text-dark-500 mt-1">Solve the math problem above</p>
                            </div>

                            <div class="flex gap-3">
                                <button type="button" 
                                        @click="showRegister = false"
                                        class="btn btn-secondary flex-1">
                                    {{ trans('main.signup.back') }}
                                </button>
                                <button type="submit" class="btn btn-primary flex-1">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"></path>
                                    </svg>
                                    {{ trans('main.signup.submit') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <div class="text-center text-sm text-dark-500">
                <p>&copy; {{ date('Y') }} {{ settings('server_name', 'Perfect World Panel') }}. All rights reserved.</p>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="{{ asset('build/app.js') }}"></script>
    <script>
        function refreshMathCaptcha() {
            fetch('{{ url("captcha/refresh") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('math-question').textContent = data.question;
                    document.getElementById('captcha').value = '';
                }
            })
            .catch(error => {
                console.error('Error refreshing captcha:', error);
            });
        }
        
        function refreshRegMathCaptcha() {
            fetch('{{ url("captcha/refresh-reg") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('reg-math-question').textContent = data.question;
                    document.getElementById('reg_captcha').value = '';
                }
            })
            .catch(error => {
                console.error('Error refreshing captcha:', error);
            });
        }
        
        // Auto-refresh captcha when switching between forms
        document.addEventListener('DOMContentLoaded', function() {
            // Refresh captcha when showing registration form
            const registerBtn = document.querySelector('[x-data] button[\\@click="showRegister = true"]');
            if (registerBtn) {
                registerBtn.addEventListener('click', function() {
                    setTimeout(refreshRegMathCaptcha, 100);
                });
            }
            
            // Refresh captcha when going back to login
            const backBtn = document.querySelector('button[\\@click="showRegister = false"]');
            if (backBtn) {
                backBtn.addEventListener('click', function() {
                    setTimeout(refreshMathCaptcha, 100);
                });
            }
        });
    </script>
</body>
</html>