@extends('front.layouts.app')

@section('content')
    @if(settings('paypal_status'))
        <div class="card mb-8">
            <div class="card-header">
                <h2 class="card-title">{{ trans('donate.paypal_title') }}</h2>
            </div>
            <div class="card-body">
                <form action="{{ url('donate/paypal') }}" onsubmit="return donationCheck();" method="post">
                    {!! csrf_field() !!}
                    
                    @if(settings('paypal_double'))
                        <div class="alert alert-info mb-6">
                            {!! trans('donate.double_notice') !!}
                        </div>
                    @endif

                    <div class="space-y-6">
                        <div>
                            <label class="form-label">Donation Amount</label>
                            <div class="flex rounded-md shadow-sm">
                                <span class="inline-flex items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 text-sm">
                                    $
                                </span>
                                <input id="donation_dollars" 
                                       name="dollars" 
                                       type="number" 
                                       step="0.01"
                                       min="{{ settings('paypal_min') }}"
                                       class="form-input rounded-none border-l-0 border-r-0 flex-1" 
                                       placeholder="0.00">
                                <span class="inline-flex items-center px-3 border border-l-0 border-r-0 border-gray-300 bg-gray-50 text-gray-500 text-sm">
                                    =
                                </span>
                                <input id="donation_tokens" 
                                       name="tokens" 
                                       type="number" 
                                       readonly
                                       class="form-input rounded-none border-l-0 flex-1 bg-gray-50" 
                                       placeholder="0">
                                <span class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-50 text-gray-500 text-sm">
                                    {{ settings('currency_name') }}
                                </span>
                            </div>
                            <p class="mt-2 text-sm text-gray-600">
                                Minimum donation: ${{ settings('paypal_min') }}
                                @if(settings('paypal_double'))
                                    <span class="text-green-600 font-medium">(Double bonus active!)</span>
                                @endif
                            </p>
                        </div>

                        <button type="submit" class="btn btn-primary btn-lg btn-block">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                            </svg>
                            {{ trans('main.buy') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    @if(settings('paymentwall_status'))
        <div class="card mb-8">
            <div class="card-header">
                <h2 class="card-title">{{ trans('donate.paymentwall_title') }}</h2>
            </div>
            <div class="card-body">
                @if(settings('paymentwall_double'))
                    <div class="alert alert-info mb-6">
                        {!! trans('donate.double_notice') !!}
                    </div>
                @endif
                
                <div class="bg-gray-50 rounded-lg p-4">
                    @if(Auth::check())
                        <iframe src="{{ str_replace(['[USER_ID]', '[USER_E]', '[USER_D]'], [Auth::user()->ID, Auth::user()->email, Auth::user()->creatime->timestamp], settings('paymentwall_link')) }}"
                                class="w-full h-96 border-0 rounded-md"
                                frameborder="0">
                        </iframe>
                    @else
                        <div class="text-center py-8">
                            <p class="text-gray-600 mb-4">Please log in to use PaymentWall</p>
                            <a href="{{ url('auth/login') }}" class="btn btn-primary">Login</a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @endif

    @if(!settings('paypal_status') && !settings('paymentwall_status'))
        <div class="card">
            <div class="card-body text-center py-12">
                <svg class="w-16 h-16 mx-auto text-gray-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                </svg>
                <h3 class="text-lg font-medium text-gray-900 mb-2">No Payment Methods Available</h3>
                <p class="text-gray-600">{{ trans('donate.no_methods') }}</p>
            </div>
        </div>
    @endif
@endsection

@push('scripts')
<script>
function donationCheck() {
    const dollarMinimum = "{{ settings('paypal_min') }}";
    const dollarsPaypal = document.getElementById('donation_tokens').value;
    const dollars = document.getElementById('donation_dollars').value;
    
    if (!dollars || !dollarsPaypal || dollars === "" || dollarsPaypal === "") {
        showToast("{!! trans('donate.error.message', ['currency' => settings('currency_name')]) !!}", 'error');
        return false;
    } else if (parseFloat(dollars) < dollarMinimum || parseFloat(dollarsPaypal) < dollarMinimum) {
        showToast("{{ trans('donate.error.minimum', ['min' => settings('paypal_min')]) }}", 'error');
        return false;
    } else {
        return true;
    }
}

document.addEventListener('DOMContentLoaded', function() {
    const perUSD = "{{ settings('paypal_per') }}";
    const doubleDonation = {{ settings('paypal_double') ? 'true' : 'false' }};
    const dollarsInput = document.getElementById('donation_dollars');
    const tokensInput = document.getElementById('donation_tokens');
    
    dollarsInput.addEventListener('input', function() {
        formatNumber('donation_dollars', 2);
        const tokens = dollarsInput.value * (doubleDonation ? perUSD * 2 : perUSD);
        tokensInput.value = Math.round(tokens);
    });
    
    tokensInput.addEventListener('input', function() {
        formatNumber('donation_tokens', 0);
        const dollars = tokensInput.value / (doubleDonation ? perUSD * 2 : perUSD);
        dollarsInput.value = dollars.toFixed(2);
    });
});
</script>
@endpush