<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ pagetitle()->get() }}</title>
    <meta name="description" content="">
    <meta name="author" content="">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Styles -->
    <link href="{{ asset('build/app.css') }}" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('favicon.ico') }}">
    
    @stack('styles')
</head>
<body class="h-full bg-gray-50">
    <div class="min-h-full">
        <!-- Navigation -->
        <nav class="navbar">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <a href="{{ url('/') }}" class="text-xl font-bold text-gray-900 hover:text-primary-600 transition-colors">
                            {{ settings('server_name', 'Perfect World Panel') }}
                        </a>
                    </div>

                    <!-- Desktop Navigation -->
                    <div class="hidden md:flex md:items-center md:space-x-8">
                        @foreach($apps as $app)
                            @if($app->enabled)
                                <a href="{{ ($app->key == 'news') ? url('/') : url('/' . $app->key) }}" 
                                   class="px-3 py-2 text-sm font-medium rounded-md transition-colors {{ 
                                       ($app->key == 'news') ? 
                                           (Request::is('/') ? 'bg-primary-100 text-primary-700' : 'text-gray-700 hover:text-primary-600') : 
                                           (Request::is($app->key . '*') ? 'bg-primary-100 text-primary-700' : 'text-gray-700 hover:text-primary-600')
                                   }}">
                                    {{ trans('main.apps.' . $app->key) }}
                                </a>
                            @endif
                        @endforeach
                    </div>

                    <!-- User Menu -->
                    <div class="flex items-center space-x-4">
                        @if(Auth::guest())
                            <a href="{{ url('auth/login') }}" class="btn btn-primary">
                                {{ trans('main.login_link') }}
                            </a>
                        @else
                            <!-- Balance (Desktop) -->
                            <div class="hidden md:block text-sm text-gray-600">
                                <a href="{{ url('donate') }}" class="hover:text-primary-600 transition-colors">
                                    {{ trans('main.acc_balance', ['money' => Auth::user()->balance(), 'currency' => settings('currency_name')]) }}
                                </a>
                            </div>

                            <!-- Character Selector -->
                            <div class="relative" x-data="{ open: false }">
                                <button @click="open = !open" 
                                        class="flex items-center space-x-2 text-sm text-gray-700 hover:text-primary-600 transition-colors">
                                    <span>{{ Auth::user()->characterId() ? Auth::user()->characterName() : trans('main.select_character') }}</span>
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                
                                <div x-show="open" @click.away="open = false" 
                                     x-transition:enter="transition ease-out duration-100"
                                     x-transition:enter-start="transform opacity-0 scale-95"
                                     x-transition:enter-end="transform opacity-100 scale-100"
                                     x-transition:leave="transition ease-in duration-75"
                                     x-transition:leave-start="transform opacity-100 scale-100"
                                     x-transition:leave-end="transform opacity-0 scale-95"
                                     class="dropdown-menu">
                                    @if($api->online)
                                        @php $roles = Auth::user()->roles() @endphp
                                        @if(count($roles) > 0)
                                            @foreach($roles as $role)
                                                <a href="{{ url('character/select/' . $role['id']) }}" class="dropdown-item">
                                                    {{ $role['name'] }}
                                                </a>
                                            @endforeach
                                        @else
                                            <span class="dropdown-item text-gray-500">
                                                {{ trans('main.char_list_error') }}
                                            </span>
                                        @endif
                                    @else
                                        <span class="dropdown-item text-gray-500">
                                            {{ trans('main.server_not_online') }}
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <!-- User Menu -->
                            <div class="relative" x-data="{ open: false }">
                                <button @click="open = !open" 
                                        class="flex items-center space-x-2 text-sm text-gray-700 hover:text-primary-600 transition-colors">
                                    @if(!$agent->isMobile())
                                        <img class="w-8 h-8 rounded-full" src="{{ Avatar::create(strtoupper(Auth::user()->name))->toBase64() }}" alt="{{ Auth::user()->name }}">
                                    @endif
                                    <span>{{ Auth::user()->name }}</span>
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                
                                <div x-show="open" @click.away="open = false" 
                                     x-transition:enter="transition ease-out duration-100"
                                     x-transition:enter-start="transform opacity-0 scale-95"
                                     x-transition:enter-end="transform opacity-100 scale-100"
                                     x-transition:leave="transition ease-in duration-75"
                                     x-transition:leave-start="transform opacity-100 scale-100"
                                     x-transition:leave-end="transform opacity-0 scale-95"
                                     class="dropdown-menu">
                                    @if(Auth::user()->isAdmin())
                                        <a href="{{ url('admin') }}" target="_blank" class="dropdown-item">
                                            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            </svg>
                                            {{ trans('main.acp_link') }}
                                        </a>
                                    @endif
                                    <a href="{{ url('account/settings') }}" class="dropdown-item">
                                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                        </svg>
                                        {{ trans('main.acc_settings') }}
                                    </a>
                                    <div class="border-t border-gray-100 my-1"></div>
                                    <a href="{{ url('auth/logout') }}" class="dropdown-item text-red-600 hover:bg-red-50">
                                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                                        </svg>
                                        {{ trans('main.logout') }}
                                    </a>
                                </div>
                            </div>
                        @endif

                        <!-- Language Selector -->
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" 
                                    class="flex items-center space-x-1 text-sm text-gray-700 hover:text-primary-600 transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                                </svg>
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                            
                            <div x-show="open" @click.away="open = false" 
                                 x-transition:enter="transition ease-out duration-100"
                                 x-transition:enter-start="transform opacity-0 scale-95"
                                 x-transition:enter-end="transform opacity-100 scale-100"
                                 x-transition:leave="transition ease-in duration-75"
                                 x-transition:leave-start="transform opacity-100 scale-100"
                                 x-transition:leave-end="transform opacity-0 scale-95"
                                 class="dropdown-menu">
                                @foreach($languages as $language)
                                    <a href="{{ Request::url() . '?language=' . $language }}" class="dropdown-item">
                                        <img src="{{ asset('img/flags/' . $language . '.png') }}" class="w-4 h-4 inline mr-2" alt="{{ $language }}">
                                        {{ trans('language.' . $language) }}
                                    </a>
                                @endforeach
                            </div>
                        </div>

                        <!-- Mobile menu button -->
                        <button id="mobile-menu-button" class="md:hidden p-2 rounded-md text-gray-700 hover:text-primary-600 hover:bg-gray-100 transition-colors">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- Mobile Navigation -->
                <div id="mobile-menu" class="hidden md:hidden border-t border-gray-200 pt-4 pb-3">
                    @foreach($apps as $app)
                        @if($app->enabled)
                            <a href="{{ ($app->key == 'news') ? url('/') : url('/' . $app->key) }}" 
                               class="block px-3 py-2 text-base font-medium rounded-md transition-colors {{ 
                                   ($app->key == 'news') ? 
                                       (Request::is('/') ? 'bg-primary-100 text-primary-700' : 'text-gray-700 hover:text-primary-600 hover:bg-gray-100') : 
                                       (Request::is($app->key . '*') ? 'bg-primary-100 text-primary-700' : 'text-gray-700 hover:text-primary-600 hover:bg-gray-100')
                               }}">
                                {{ trans('main.apps.' . $app->key) }}
                            </a>
                        @endif
                    @endforeach
                    
                    @if(Auth::check())
                        <div class="border-t border-gray-200 mt-3 pt-3">
                            <div class="px-3 py-2 text-sm text-gray-600">
                                {{ trans('main.acc_balance', ['money' => Auth::user()->balance(), 'currency' => settings('currency_name')]) }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </nav>

        <!-- Breadcrumbs -->
        @if(Breadcrumbs::exists())
            <div class="bg-white border-b border-gray-200">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-3">
                    {!! Breadcrumbs::render() !!}
                </div>
            </div>
        @endif

        <!-- Main Content -->
        <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
            <!-- Flash Messages -->
            @include('errors.list')
            @include('flash::message')

            <div class="grid grid-cols-1 {{ Request::is('shop*') ? '' : 'lg:grid-cols-4' }} gap-8">
                <!-- Main Content -->
                <div class="{{ Request::is('shop*') ? 'col-span-1' : 'lg:col-span-3' }}">
                    @yield('content')
                </div>

                <!-- Sidebar -->
                @unless(Request::is('shop*'))
                    <div class="lg:col-span-1">
                        @include('front.widgets')
                    </div>
                @endunless
            </div>
        </main>

        <!-- Footer -->
        @include('front.layouts.footer')
    </div>

    <!-- Scripts -->
    <script src="{{ asset('build/app.js') }}"></script>
    @stack('scripts')
    @yield('footer')
</body>
</html>