<!-- Footer -->
<footer class="bg-dark-100/80 backdrop-blur-xl border-t border-dark-200/50 mt-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Server Info -->
            <div class="text-center md:text-left">
                <h3 class="text-lg font-semibold text-dark-800 mb-4">{{ settings('server_name', 'Perfect World Panel') }}</h3>
                <p class="text-dark-500 text-sm leading-relaxed">
                    Experience the ultimate Perfect World adventure with enhanced gameplay, active community, and regular events.
                </p>
            </div>

            <!-- Quick Links -->
            <div class="text-center">
                <h3 class="text-lg font-semibold text-dark-800 mb-4">Quick Links</h3>
                <div class="space-y-2">
                    <a href="{{ url('/') }}" class="block text-dark-500 hover:text-primary-400 text-sm transition-colors">News</a>
                    <a href="{{ url('shop') }}" class="block text-dark-500 hover:text-primary-400 text-sm transition-colors">Item Shop</a>
                    <a href="{{ url('ranking') }}" class="block text-dark-500 hover:text-primary-400 text-sm transition-colors">Rankings</a>
                    <a href="{{ url('vote') }}" class="block text-dark-500 hover:text-primary-400 text-sm transition-colors">Vote</a>
                </div>
            </div>

            <!-- Support -->
            <div class="text-center md:text-right">
                <h3 class="text-lg font-semibold text-dark-800 mb-4">Support Development</h3>
                <p class="text-dark-500 text-sm mb-4">Help us improve the panel</p>
                <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=R9FB8E4X5EYVC" 
                   target="_blank" 
                   class="btn btn-primary inline-flex items-center hover:scale-105 transition-transform duration-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                    </svg>
                    Donate
                </a>
            </div>
        </div>

        <!-- Bottom Bar -->
        <div class="border-t border-dark-200/50 mt-8 pt-8 text-center">
            <p class="text-dark-500 text-sm">
                &copy; {{ date('Y') }} {{ settings('server_name', 'Perfect World Panel') }}. All rights reserved.
            </p>
        </div>
    </div>
</footer>

<!-- Scroll to top button -->
<button id="scroll-to-top" 
        class="fixed bottom-6 right-6 w-12 h-12 bg-gradient-to-r from-primary-500 to-primary-600 text-white rounded-full shadow-lg hover:shadow-xl hover:from-primary-600 hover:to-primary-700 transition-all duration-300 opacity-0 invisible transform hover:scale-110 z-50"
        onclick="window.scrollTo({top: 0, behavior: 'smooth'})">
    <svg class="w-5 h-5 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
    </svg>
</button>

<script>
// Show/hide scroll to top button with smooth animation
window.addEventListener('scroll', function() {
    const scrollButton = document.getElementById('scroll-to-top');
    if (window.pageYOffset > 300) {
        scrollButton.classList.remove('opacity-0', 'invisible');
        scrollButton.classList.add('opacity-100', 'visible');
    } else {
        scrollButton.classList.add('opacity-0', 'invisible');
        scrollButton.classList.remove('opacity-100', 'visible');
    }
});

// Add smooth scroll behavior for all anchor links
document.addEventListener('DOMContentLoaded', function() {
    const links = document.querySelectorAll('a[href^="#"]');
    links.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
});
</script>