<!DOCTYPE html>
<html lang="en" class="h-full dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ pagetitle()->get() }}</title>
    <meta name="description" content="">
    <meta name="author" content="">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Styles -->
    <link href="{{ asset('build/app.css') }}" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('favicon.ico') }}">
    
    @stack('styles')
</head>
<body class="h-full bg-gradient-dark text-dark-800 antialiased">
    <div class="min-h-full">
        <!-- Navigation -->
        <nav class="navbar">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-2">
                <div class="flex justify-between h-20 items-center">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <a href="{{ url('/') }}" class="text-xl font-bold text-dark-800 hover:text-primary-400 transition-colors">
                            {{ settings('server_name', 'Perfect World Panel') }}
                        </a>
                    </div>

                    <!-- Desktop Navigation -->
                    <div class="hidden md:flex md:items-center md:space-x-8">
                        <!-- News -->
                        <a href="{{ url('/') }}" 
                           class="px-3 py-2 text-sm font-medium rounded-lg transition-colors bg-primary-500/20 text-primary-400">
                            <i class="fas fa-newspaper mr-2"></i>{{ trans('main.apps.news') }}
                        </a>

                        <!-- Shop -->
                        <a href="{{ url('/shop') }}" 
                           class="px-3 py-2 text-sm font-medium rounded-lg transition-colors text-dark-600 hover:text-primary-400 hover:bg-dark-200/50">
                            <i class="fas fa-shopping-cart mr-2"></i>{{ trans('main.apps.shop') }}
                        </a>

                        <!-- Community Dropdown -->
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" 
                                    class="flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-colors text-dark-600 hover:text-primary-400 hover:bg-dark-200/50">
                                <i class="fas fa-users mr-2"></i>Community
                                <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                            
                            <div x-show="open" @click.away="open = false" 
                                 x-transition:enter="transition ease-out duration-100"
                                 x-transition:enter-start="transform opacity-0 scale-95"
                                 x-transition:enter-end="transform opacity-100 scale-100"
                                 x-transition:leave="transition ease-in duration-75"
                                 x-transition:leave-start="transform opacity-100 scale-100"
                                 x-transition:leave-end="transform opacity-0 scale-95"
                                 class="absolute right-0 mt-2 w-48 rounded-lg shadow-xl border border-gray-600 py-1 z-50"
                                 style="background-color: #1f2937 !important; backdrop-filter: blur(10px);">
                                <a href="{{ url('/ranking') }}" class="block px-4 py-2 text-sm text-gray-200 hover:text-primary-400 transition-colors" style="background-color: transparent;" onmouseover="this.style.backgroundColor='#374151'" onmouseout="this.style.backgroundColor='transparent'">
                                    <i class="fas fa-trophy mr-2"></i>{{ trans('main.apps.ranking') }}
                                </a>
                                <a href="{{ url('/daily-spin') }}" class="block px-4 py-2 text-sm text-gray-200 hover:text-primary-400 transition-colors" style="background-color: transparent;" onmouseover="this.style.backgroundColor='#374151'" onmouseout="this.style.backgroundColor='transparent'">
                                    <i class="fas fa-sync-alt mr-2"></i>{{ trans('main.apps.daily-spin') }}
                                </a>
                                <a href="{{ url('/vote') }}" class="block px-4 py-2 text-sm text-gray-200 hover:text-primary-400 transition-colors" style="background-color: transparent;" onmouseover="this.style.backgroundColor='#374151'" onmouseout="this.style.backgroundColor='transparent'">
                                    <i class="fas fa-thumbs-up mr-2"></i>{{ trans('main.apps.vote') }}
                                </a>
                            </div>
                        </div>

                        <!-- Services Dropdown -->
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" 
                                    class="flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-colors text-dark-600 hover:text-primary-400 hover:bg-dark-200/50">
                                <i class="fas fa-cogs mr-2"></i>Services
                                <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                            
                            <div x-show="open" @click.away="open = false" 
                                 x-transition:enter="transition ease-out duration-100"
                                 x-transition:enter-start="transform opacity-0 scale-95"
                                 x-transition:enter-end="transform opacity-100 scale-100"
                                 x-transition:leave="transition ease-in duration-75"
                                 x-transition:leave-start="transform opacity-100 scale-100"
                                 x-transition:leave-end="transform opacity-0 scale-95"
                                 class="absolute right-0 mt-2 w-48 rounded-lg shadow-xl border border-gray-600 py-1 z-50"
                                 style="background-color: #1f2937 !important; backdrop-filter: blur(10px);">
                                <a href="{{ url('/donate') }}" class="block px-4 py-2 text-sm text-gray-200 hover:text-primary-400 transition-colors" style="background-color: transparent;" onmouseover="this.style.backgroundColor='#374151'" onmouseout="this.style.backgroundColor='transparent'">
                                    <i class="fas fa-credit-card mr-2"></i>{{ trans('main.apps.donate') }}
                                </a>
                                <a href="{{ url('/services') }}" class="block px-4 py-2 text-sm text-gray-200 hover:text-primary-400 transition-colors" style="background-color: transparent;" onmouseover="this.style.backgroundColor='#374151'" onmouseout="this.style.backgroundColor='transparent'">
                                    <i class="fas fa-tools mr-2"></i>{{ trans('main.apps.services') }}
                                </a>
                                <a href="{{ url('/voucher') }}" class="block px-4 py-2 text-sm text-gray-200 hover:text-primary-400 transition-colors" style="background-color: transparent;" onmouseover="this.style.backgroundColor='#374151'" onmouseout="this.style.backgroundColor='transparent'">
                                    <i class="fas fa-tag mr-2"></i>{{ trans('main.apps.voucher') }}
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- User Menu -->
                    <div class="flex items-center space-x-4">
                        @if(Auth::guest())
                            <a href="{{ url('auth/login') }}" class="btn btn-primary">
                                {{ trans('main.login_link') }}
                            </a>
                        @else
                            <!-- Balance (Desktop) -->
                            <div class="hidden md:block text-sm text-dark-500">
                                <a href="{{ url('donate') }}" class="hover:text-primary-400 transition-colors px-3 py-1 rounded-lg hover:bg-dark-200/50 flex items-center">
                                    <i class="fas fa-wallet mr-2"></i>{{ Auth::user() ? Auth::user()->balance() : '0.00' }} {{ settings('currency_name', 'coins') }}
                                </a>
                            </div>

                            <!-- User Menu -->
                            <div class="relative" x-data="{ open: false }">
                                <button @click="open = !open" 
                                        class="flex items-center space-x-2 text-sm text-gray-700 hover:text-primary-600 transition-colors">
                                    @if(!$agent->isMobile() && Auth::user())
                                        <img class="w-8 h-8 rounded-full" src="{{ Avatar::create(strtoupper(Auth::user()->name))->toBase64() }}" alt="{{ Auth::user()->name }}">
                                    @endif
                                    <span>{{ Auth::user() ? Auth::user()->name : 'Guest' }}</span>
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                
                                <div x-show="open" @click.away="open = false" 
                                     x-transition:enter="transition ease-out duration-100"
                                     x-transition:enter-start="transform opacity-0 scale-95"
                                     x-transition:enter-end="transform opacity-100 scale-100"
                                     x-transition:leave="transition ease-in duration-75"
                                     x-transition:leave-start="transform opacity-100 scale-100"
                                     x-transition:leave-end="transform opacity-0 scale-95"
                                     class="dropdown-menu">
                                    @if(Auth::user() && Auth::user()->isAdmin())
                                        <a href="{{ url('admin') }}" target="_blank" class="dropdown-item">
                                            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            </svg>
                                            {{ trans('main.acp_link') }}
                                        </a>
                                    @endif
                                    <a href="{{ url('account/settings') }}" class="dropdown-item">
                                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                        </svg>
                                        {{ trans('main.acc_settings') }}
                                    </a>
                                    <div class="border-t border-gray-100 my-1"></div>
                                    <a href="{{ url('auth/logout') }}" class="dropdown-item text-red-600 hover:bg-red-50">
                                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                                        </svg>
                                        {{ trans('main.logout') }}
                                    </a>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content - NO SIDEBAR, NO WIDGETS -->
        <main>
            <!-- Flash Messages -->
            @include('errors.list')
            @include('flash::message')

            @yield('content')
        </main>

        <!-- Footer -->
        @include('front.layouts.footer')
    </div>

    <!-- Scripts -->
    <script src="{{ asset('build/app.js') }}"></script>
    @stack('scripts')
    @yield('footer')
</body>
</html>