<!-- Sidebar Widgets -->
<div class="space-y-6">
    <!-- Game Masters Widget -->
    @if(count($gms) > 0)
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">{{ trans('widget.gms_title') }}</h3>
            </div>
            <div class="card-body p-0">
                <ul class="divide-y divide-gray-200">
                    @foreach($gms as $gm)
                        <li class="px-6 py-3 flex items-center justify-between">
                            <span class="text-sm font-medium text-gray-900">{{ $gm->name }}</span>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $gm->online() == TRUE ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                <svg class="w-2 h-2 mr-1 {{ $gm->online() ? 'text-green-400' : 'text-red-400' }}" fill="currentColor" viewBox="0 0 8 8">
                                    <circle cx="4" cy="4" r="3"/>
                                </svg>
                                {{ $gm->online() ? trans('widget.server_status_online') : trans('widget.server_status_offline') }}
                            </span>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    @endif

    <!-- Server Status Widget -->
    <div class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60 hover:bg-gray-700/95 transition-all duration-300">
        <div class="p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-14 h-14 {{ $api->online ? 'bg-gradient-to-br from-emerald-500/20 to-green-500/30' : 'bg-gradient-to-br from-red-500/20 to-rose-500/30' }} rounded-2xl flex items-center justify-center {{ $api->online ? 'pulse-glow' : '' }}">
                        <svg class="w-7 h-7 {{ $api->online ? 'text-emerald-400' : 'text-red-400' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            @if($api->online)
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            @else
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            @endif
                        </svg>
                    </div>
                </div>
                <div class="ml-5">
                    <h3 class="text-lg font-semibold {{ $api->online ? 'text-emerald-400' : 'text-red-400' }} tracking-tight">
                        {{ $api->online ? trans('widget.server_status_online') : trans('widget.server_status_offline') }}
                    </h3>
                    <p class="text-sm text-dark-500 font-medium">{{ trans('widget.server_status_title') }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Players Online Widget -->
    <div class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60 hover:bg-gray-700/95 transition-all duration-300">
        <div class="p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-14 h-14 bg-gradient-to-br from-primary-500/20 to-cyan-500/30 rounded-2xl flex items-center justify-center">
                        <svg class="w-7 h-7 text-primary-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-5">
                    <h3 class="text-2xl font-bold gradient-text tracking-tight" data-counter="counterup" data-value="{{ $api->online ? count($api->getOnlineList()) : 0 }}">
                        0
                    </h3>
                    <p class="text-sm text-dark-500 font-medium">{{ trans('widget.players_online_title') }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Registered Accounts Widget -->
    <div class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60 hover:bg-gray-700/95 transition-all duration-300">
        <div class="p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-14 h-14 bg-gradient-to-br from-purple-500/20 to-violet-500/30 rounded-2xl flex items-center justify-center">
                        <svg class="w-7 h-7 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                </div>
                <div class="ml-5">
                    <h3 class="text-2xl font-bold text-purple-400 tracking-tight" data-counter="counterup" data-value="{{ DB::table('point')->count() }}">
                        0
                    </h3>
                    <p class="text-sm text-dark-500 font-medium">{{ trans('widget.acc_registered_title') }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Social Media Widget -->
    <div class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60">
        <div class="p-4 border-b border-gray-700/60">
            <h3 class="text-lg font-bold text-white flex items-center">
                <i class="fas fa-users mr-2 text-blue-400"></i>
                {{ trans('widget.join_our_community') }}
            </h3>
        </div>
        <div class="p-6">
            <div class="space-y-3">
                @if(!empty($widget_links))
                    @foreach($widget_links as $link)
                <a href="{{ $link['url'] ?? '#' }}" target="_blank" class="flex items-center p-3 bg-gray-700/50 rounded-lg hover:bg-gray-600/50 transition-colors group">
                    <div class="w-10 h-10 bg-indigo-500/20 rounded-lg flex items-center justify-center mr-3 group-hover:bg-indigo-500/30 transition-colors">
                        <svg class="w-5 h-5 text-indigo-400" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M20.317 4.37a19.791 19.791 0 0 0-4.885-1.515a.074.074 0 0 0-.079.037c-.21.375-.444.864-.608 1.25a18.27 18.27 0 0 0-5.487 0a12.64 12.64 0 0 0-.617-1.25a.077.077 0 0 0-.079-.037A19.736 19.736 0 0 0 3.677 4.37a.07.07 0 0 0-.032.027C.533 9.046-.32 13.58.099 18.057a.082.082 0 0 0 .031.057a19.9 19.9 0 0 0 5.993 3.03a.078.078 0 0 0 .084-.028a14.09 14.09 0 0 0 1.226-1.994a.076.076 0 0 0-.041-.106a13.107 13.107 0 0 1-1.872-.892a.077.077 0 0 1-.008-.128a10.2 10.2 0 0 0 .372-.292a.074.074 0 0 1 .077-.01c3.928 1.793 8.18 1.793 12.062 0a.074.074 0 0 1 .078.01c.12.098.246.198.373.292a.077.077 0 0 1-.006.127a12.299 12.299 0 0 1-1.873.892a.077.077 0 0 0-.041.107c.36.698.772 1.362 1.225 1.993a.076.076 0 0 0 .084.028a19.839 19.839 0 0 0 6.002-3.03a.077.077 0 0 0 .032-.054c.5-5.177-.838-9.674-3.549-13.66a.061.061 0 0 0-.031-.03zM8.02 15.33c-1.183 0-2.157-1.085-2.157-2.419c0-1.333.956-2.419 2.157-2.419c1.21 0 2.176 1.096 2.157 2.42c0 1.333-.956 2.418-2.157 2.418zm7.975 0c-1.183 0-2.157-1.085-2.157-2.419c0-1.333.955-2.419 2.157-2.419c1.21 0 2.176 1.096 2.157 2.42c0 1.333-.946 2.418-2.157 2.418z"/>
                        </svg>
                    </div>
                    <div>
                        <div class="text-white font-medium">{{ $link['label'] }}</div>
                        <div class="text-gray-400 text-sm">{{ $link['label'] }}</div>
                    </div>
                </a>
                    @endforeach
                @endif
            </div>
        </div>
    </div>

    @if(Auth::check())
    <!-- Quick Actions Widget -->
    <div class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60">
        <div class="p-6 border-b border-gray-700/40">
            <h3 class="text-lg font-bold text-white">Quick Actions</h3>
        </div>
        <div class="p-0">
            <div class="space-y-1">
                <a href="{{ url('donate') }}" class="flex items-center px-6 py-3 text-sm text-gray-300 hover:bg-gray-700/50 hover:text-green-400 transition-colors rounded-lg mx-2">
                    <svg class="w-4 h-4 mr-3 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                    Add Credits
                </a>
                <a href="{{ url('shop') }}" class="flex items-center px-6 py-3 text-sm text-gray-300 hover:bg-gray-700/50 hover:text-blue-400 transition-colors rounded-lg mx-2">
                    <svg class="w-4 h-4 mr-3 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                    </svg>
                    Item Shop
                </a>
                <a href="{{ url('vote') }}" class="flex items-center px-6 py-3 text-sm text-gray-300 hover:bg-gray-700/50 hover:text-purple-400 transition-colors rounded-lg mx-2">
                    <svg class="w-4 h-4 mr-3 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                    </svg>
                    Vote for Rewards
                </a>
                <a href="{{ url('account/settings') }}" class="flex items-center px-6 py-3 text-sm text-gray-300 hover:bg-gray-700/50 hover:text-gray-400 transition-colors rounded-lg mx-2">
                    <svg class="w-4 h-4 mr-3 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    Account Settings
                </a>
            </div>
        </div>
    </div>
    @endif
</div>

@push('scripts')
<script>
// Simple counter animation (same as original)
document.addEventListener('DOMContentLoaded', function() {
    const counters = document.querySelectorAll('[data-counter="counterup"]');
    
    counters.forEach(counter => {
        const target = parseInt(counter.getAttribute('data-value'));
        const duration = 2000; // 2 seconds
        const step = target / (duration / 16); // 60fps
        let current = 0;
        
        const timer = setInterval(() => {
            current += step;
            if (current >= target) {
                counter.textContent = target;
                clearInterval(timer);
            } else {
                counter.textContent = Math.floor(current);
            }
        }, 16);
    });
});
</script>
@endpush