@extends('front.layouts.app')

{{-- MODERN NEWS LAYOUT WITH SIDEBAR --}}

@section('content')
<!-- Hero Section -->
<div class="relative overflow-hidden bg-gradient-to-br from-primary-900/20 via-dark-800/50 to-dark-900/80 border-b border-dark-600/30 rounded-xl mb-8">
    <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.02"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-20"></div>
    <div class="relative px-6 py-12">
        <div class="text-center">
            <div class="inline-flex items-center px-4 py-2 rounded-full bg-primary-500/10 border border-primary-500/20 text-primary-300 text-sm font-medium mb-6">
                <i class="fas fa-newspaper mr-2"></i>
                {{ trans('news.latest_updates') }}
            </div>
                <h1 class="text-5xl md:text-6xl font-bold mb-6">
                    <span class="bg-gradient-to-r from-primary-400 via-primary-300 to-blue-400 bg-clip-text text-transparent">
                        {{ trans('news.news_announcements') }}
                    </span>
                </h1>
                <p class="text-xl text-dark-300 max-w-3xl mx-auto leading-relaxed">
                    {{ trans('news.news_description') }}
                </p>
            </div>
        </div>
    </div>

    <!-- Main Content Area -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
            
            <!-- News Articles - Main Content (3/4 width) -->
            <div class="lg:col-span-3 space-y-8">
                @if($articles->count() > 0)
                    @foreach($articles as $article)
                        <article class="group">
                            <!-- Article Card - Updated {{ date('H:i:s') }} -->
                            <div class="bg-gray-800/95 rounded-xl overflow-hidden hover:bg-gray-700/95 transition-all duration-300 shadow-lg border border-gray-700/60 hover:border-gray-600/80">
                                
                                <!-- Article Header -->
                                <div class="p-8 pb-6 relative">
                                    <!-- Category Badge -->
                                    <div class="absolute top-8 right-8">
                                        @if(isset($article->category) && $article->category == 'update')
                                            <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-semibold bg-gradient-to-r from-blue-500/30 to-blue-600/40 text-blue-200 backdrop-blur-sm shadow-lg">
                                                <i class="fas fa-info-circle mr-2"></i>{{ trans('news.category.update') }}
                                            </span>
                                        @elseif(isset($article->category) && $article->category == 'maintenance')
                                            <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-semibold bg-gradient-to-r from-amber-500/30 to-orange-600/40 text-amber-200 backdrop-blur-sm shadow-lg">
                                                <i class="fas fa-tools mr-2"></i>{{ trans('news.category.maintenance') }}
                                            </span>
                                        @elseif(isset($article->category) && $article->category == 'event')
                                            <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-semibold bg-gradient-to-r from-emerald-500/30 to-green-600/40 text-emerald-200 backdrop-blur-sm shadow-lg">
                                                <i class="fas fa-calendar-star mr-2"></i>{{ trans('news.category.event') }}
                                            </span>
                                        @elseif(isset($article->category) && $article->category == 'contest')
                                            <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-semibold bg-gradient-to-r from-purple-500/30 to-violet-600/40 text-purple-200 backdrop-blur-sm shadow-lg">
                                                <i class="fas fa-trophy mr-2"></i>{{ trans('news.category.contest') }}
                                            </span>
                                        @else
                                            <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-semibold bg-gradient-to-r from-dark-500/30 to-dark-600/40 text-dark-200 backdrop-blur-sm shadow-lg">
                                                <i class="fas fa-newspaper mr-2"></i>{{ trans('news.category.other') }}
                                            </span>
                                        @endif
                                    </div>

                                    <!-- Title -->
                                    <h2 class="text-3xl font-bold text-white mb-6 pr-32 group-hover:text-primary-300 transition-colors leading-tight">
                                        {{ $article->title }}
                                    </h2>

                                    <!-- Meta Information -->
                                    <div class="flex items-center space-x-8 text-sm text-dark-400">
                                        <div class="flex items-center">
                                            <div class="w-8 h-8 bg-primary-500/20 rounded-full flex items-center justify-center mr-3">
                                                <i class="fas fa-calendar-alt text-primary-400 text-xs"></i>
                                            </div>
                                            <span class="font-medium">{{ $article->created_at->format('M d, Y') }}</span>
                                        </div>
                                        <div class="flex items-center">
                                            <div class="w-8 h-8 bg-primary-500/20 rounded-full flex items-center justify-center mr-3">
                                                <i class="fas fa-clock text-primary-400 text-xs"></i>
                                            </div>
                                            <span class="font-medium">{{ $article->created_at->format('g:i A') }}</span>
                                        </div>
                                        <div class="flex items-center">
                                            <div class="w-8 h-8 bg-primary-500/20 rounded-full flex items-center justify-center mr-3">
                                                <i class="fas fa-eye text-primary-400 text-xs"></i>
                                            </div>
                                            <span class="font-medium">{{ $article->created_at->diffForHumans() }}</span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Article Content -->
                                <div class="px-8 pb-8">
                                    <div class="prose prose-lg max-w-none">
                                        <div class="news-content">
                                            {!! $article->content !!}
                                        </div>
                                    </div>
                                </div>

                                <!-- Article Footer -->
                                <div class="px-8 py-6 bg-gray-900/50 border-t border-gray-700/40">
                                    <div class="flex items-center justify-between">
                                        <div class="flex items-center space-x-4">
                                            <span class="text-sm text-dark-400">
                                                {{ trans('news.published') }} {{ $article->created_at->diffForHumans() }}
                                            </span>
                                            @if($article->updated_at != $article->created_at)
                                                <span class="text-xs text-dark-500">
                                                    • {{ trans('news.updated') }} {{ $article->updated_at->diffForHumans() }}
                                                </span>
                                            @endif
                                        </div>
                                        <div class="flex items-center space-x-3">
                                            <button class="flex items-center space-x-2 text-dark-400 hover:text-primary-400 transition-colors group/btn">
                                                <div class="w-8 h-8 bg-dark-700/50 group-hover/btn:bg-primary-500/20 rounded-full flex items-center justify-center transition-colors">
                                                    <i class="fas fa-share-alt text-xs"></i>
                                                </div>
                                                <span class="text-sm font-medium">{{ trans('news.share') }}</span>
                                            </button>
                                            <button class="flex items-center space-x-2 text-dark-400 hover:text-red-400 transition-colors group/btn">
                                                <div class="w-8 h-8 bg-dark-700/50 group-hover/btn:bg-red-500/20 rounded-full flex items-center justify-center transition-colors">
                                                    <i class="fas fa-heart text-xs"></i>
                                                </div>
                                                <span class="text-sm font-medium">{{ trans('news.like') }}</span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </article>
                    @endforeach

                    <!-- Pagination -->
                    @if($articles->hasPages())
                        <div class="flex justify-center mt-16">
                            <nav class="flex items-center space-x-2">
                                {{-- Previous Page Link --}}
                                @if($articles->onFirstPage())
                                    <span class="px-6 py-3 text-sm text-gray-500 bg-gray-800/80 rounded-lg cursor-not-allowed border border-gray-700/50">
                                        <i class="fas fa-chevron-left mr-2"></i>{{ trans('news.previous') }}
                                    </span>
                                @else
                                    <a href="{{ $articles->previousPageUrl() }}" 
                                       class="px-6 py-3 text-sm text-gray-300 bg-gray-800/80 rounded-lg hover:bg-gray-700/90 hover:text-primary-300 transition-all border border-gray-700/50 hover:border-primary-500/60">
                                        <i class="fas fa-chevron-left mr-2"></i>{{ trans('news.previous') }}
                                    </a>
                                @endif

                                {{-- Page Numbers --}}
                                @foreach($articles->getUrlRange(1, $articles->lastPage()) as $page => $url)
                                    @if($page == $articles->currentPage())
                                        <span class="px-4 py-3 text-sm text-white bg-primary-600 rounded-lg font-semibold border border-primary-500/60">
                                            {{ $page }}
                                        </span>
                                    @else
                                        <a href="{{ $url }}" 
                                           class="px-4 py-3 text-sm text-gray-300 bg-gray-800/80 rounded-lg hover:bg-gray-700/90 hover:text-primary-300 transition-all border border-gray-700/50 hover:border-primary-500/60">
                                            {{ $page }}
                                        </a>
                                    @endif
                                @endforeach

                                {{-- Next Page Link --}}
                                @if($articles->hasMorePages())
                                    <a href="{{ $articles->nextPageUrl() }}" 
                                       class="px-6 py-3 text-sm text-gray-300 bg-gray-800/80 rounded-lg hover:bg-gray-700/90 hover:text-primary-300 transition-all border border-gray-700/50 hover:border-primary-500/60">
                                        {{ trans('news.next') }}<i class="fas fa-chevron-right ml-2"></i>
                                    </a>
                                @else
                                    <span class="px-6 py-3 text-sm text-gray-500 bg-gray-800/80 rounded-lg cursor-not-allowed border border-gray-700/50">
                                        {{ trans('news.next') }}<i class="fas fa-chevron-right ml-2"></i>
                                    </span>
                                @endif
                            </nav>
                        </div>
                    @endif

                @else
                    <!-- No Articles State -->
                    <div class="text-center py-20">
                        <div class="bg-gray-800/95 rounded-xl p-16 max-w-md mx-auto shadow-lg border border-gray-700/60">
                            <div class="w-24 h-24 mx-auto mb-8 bg-gradient-to-br from-primary-500/20 to-primary-600/30 rounded-full flex items-center justify-center">
                                <i class="fas fa-newspaper text-4xl text-primary-400"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-white mb-4">{{ trans('news.no_news_title') }}</h3>
                            <p class="text-dark-400 leading-relaxed">
                                {{ trans('news.no_news_description') }}
                            </p>
                        </div>
                    </div>
                @endif
            </div>

            <!-- Sidebar (1/4 width) -->
            <div class="lg:col-span-1">
                <div class="space-y-6">
                    
                    <!-- Server Status Widget -->
                    <div class="bg-gray-800/95 rounded-xl p-6 shadow-lg border border-gray-700/60">
                        <div class="flex items-center mb-6">
                            <div class="w-12 h-12 {{ $api->online ? 'bg-gradient-to-br from-emerald-500/20 to-green-500/30' : 'bg-gradient-to-br from-red-500/20 to-rose-500/30' }} rounded-xl flex items-center justify-center mr-4">
                                <i class="fas {{ $api->online ? 'fa-check-circle' : 'fa-times-circle' }} text-xl {{ $api->online ? 'text-emerald-400' : 'text-red-400' }}"></i>
                            </div>
                            <div>
                                <h3 class="text-lg font-bold {{ $api->online ? 'text-emerald-400' : 'text-red-400' }}">
                                    {{ $api->online ? trans('news.server_online') : trans('news.server_offline') }}
                                </h3>
                                <p class="text-sm text-dark-400">{{ trans('news.current_status') }}</p>
                            </div>
                        </div>
                        
                        <div class="space-y-4">
                            <div class="flex justify-between items-center">
                                <span class="text-dark-300 font-medium">{{ trans('news.players_online') }}</span>
                                <span class="text-primary-400 font-bold text-lg">{{ $api->online ? count($api->getOnlineList()) : '0' }}</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-dark-300 font-medium">{{ trans('news.total_accounts') }}</span>
                                <span class="text-emerald-400 font-bold text-lg">{{ number_format(DB::table('point')->count()) }}</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-dark-300 font-medium">{{ trans('news.uptime') }}</span>
                                <span class="text-purple-400 font-bold text-lg">99.9%</span>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Actions Widget -->
                    @if(Auth::check())
                        <div class="bg-gray-800/95 rounded-xl p-6 shadow-lg border border-gray-700/60">
                            <h3 class="text-lg font-bold text-white mb-6 flex items-center">
                                <i class="fas fa-bolt mr-3 text-primary-400"></i>
                                {{ trans('news.quick_actions') }}
                            </h3>
                            <div class="space-y-3">
                                <a href="{{ url('donate') }}" class="flex items-center p-4 bg-gray-700/80 hover:bg-green-600/20 rounded-lg transition-all group border border-gray-600/50 hover:border-green-500/60">
                                    <div class="w-10 h-10 bg-green-500/20 group-hover:bg-green-500/30 rounded-lg flex items-center justify-center mr-4 transition-colors">
                                        <i class="fas fa-credit-card text-green-400"></i>
                                    </div>
                                    <div>
                                        <p class="text-white font-semibold group-hover:text-green-300 transition-colors">{{ trans('news.add_credits') }}</p>
                                        <p class="text-xs text-dark-400">{{ trans('news.support_server') }}</p>
                                    </div>
                                </a>
                                
                                <a href="{{ url('shop') }}" class="flex items-center p-4 bg-gray-700/80 hover:bg-blue-600/20 rounded-lg transition-all group border border-gray-600/50 hover:border-blue-500/60">
                                    <div class="w-10 h-10 bg-primary-500/20 group-hover:bg-primary-500/30 rounded-lg flex items-center justify-center mr-4 transition-colors">
                                        <i class="fas fa-shopping-bag text-primary-400"></i>
                                    </div>
                                    <div>
                                        <p class="text-white font-semibold group-hover:text-primary-300 transition-colors">{{ trans('news.item_shop') }}</p>
                                        <p class="text-xs text-dark-400">{{ trans('news.browse_items') }}</p>
                                    </div>
                                </a>
                                
                                <a href="{{ url('daily-spin') }}" class="flex items-center p-4 bg-gray-700/80 hover:bg-purple-600/20 rounded-lg transition-all group border border-gray-600/50 hover:border-purple-500/60">
                                    <div class="w-10 h-10 bg-purple-500/20 group-hover:bg-purple-500/30 rounded-lg flex items-center justify-center mr-4 transition-colors">
                                        <i class="fas fa-sync-alt text-purple-400"></i>
                                    </div>
                                    <div>
                                        <p class="text-white font-semibold group-hover:text-purple-300 transition-colors">{{ trans('news.daily_spin') }}</p>
                                        <p class="text-xs text-dark-400">{{ trans('news.free_rewards') }}</p>
                                    </div>
                                </a>
                            </div>
                        </div>
                    @endif

                    <!-- Social Media Widget -->
                    <div class="bg-gray-800/95 rounded-xl p-6 shadow-lg border border-gray-700/60">
                        <h3 class="text-lg font-bold text-white mb-6 flex items-center">
                            <i class="fas fa-users mr-3 text-primary-400"></i>
                            Join Our Community
                        </h3>
                        <div class="space-y-3">
                            <a href="{{ settings('discord_link', '#') }}" target="_blank" class="flex items-center p-4 bg-gray-700/80 hover:bg-indigo-600/20 rounded-lg transition-all group border border-gray-600/50 hover:border-indigo-500/60">
                                <div class="w-10 h-10 bg-indigo-500/20 group-hover:bg-indigo-500/30 rounded-lg flex items-center justify-center mr-4 transition-colors">
                                    <svg class="w-5 h-5 text-indigo-400" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M20.317 4.37a19.791 19.791 0 0 0-4.885-1.515a.074.074 0 0 0-.079.037c-.21.375-.444.864-.608 1.25a18.27 18.27 0 0 0-5.487 0a12.64 12.64 0 0 0-.617-1.25a.077.077 0 0 0-.079-.037A19.736 19.736 0 0 0 3.677 4.37a.07.07 0 0 0-.032.027C.533 9.046-.32 13.58.099 18.057a.082.082 0 0 0 .031.057a19.9 19.9 0 0 0 5.993 3.03a.078.078 0 0 0 .084-.028a14.09 14.09 0 0 0 1.226-1.994a.076.076 0 0 0-.041-.106a13.107 13.107 0 0 1-1.872-.892a.077.077 0 0 1-.008-.128a10.2 10.2 0 0 0 .372-.292a.074.074 0 0 1 .077-.01c3.928 1.793 8.18 1.793 12.062 0a.074.074 0 0 1 .078.01c.12.098.246.198.373.292a.077.077 0 0 1-.006.127a12.299 12.299 0 0 1-1.873.892a.077.077 0 0 0-.041.107c.36.698.772 1.362 1.225 1.993a.076.076 0 0 0 .084.028a19.839 19.839 0 0 0 6.002-3.03a.077.077 0 0 0 .032-.054c.5-5.177-.838-9.674-3.549-13.66a.061.061 0 0 0-.031-.03zM8.02 15.33c-1.183 0-2.157-1.085-2.157-2.419c0-1.333.956-2.419 2.157-2.419c1.21 0 2.176 1.096 2.157 2.42c0 1.333-.956 2.418-2.157 2.418zm7.975 0c-1.183 0-2.157-1.085-2.157-2.419c0-1.333.955-2.419 2.157-2.419c1.21 0 2.176 1.096 2.157 2.42c0 1.333-.946 2.418-2.157 2.418z"/>
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-white font-semibold group-hover:text-indigo-300 transition-colors">Discord</p>
                                    <p class="text-xs text-dark-400">Chat with players</p>
                                </div>
                            </a>
                            
                            <a href="{{ settings('telegram_link', '#') }}" target="_blank" class="flex items-center p-4 bg-gray-700/80 hover:bg-blue-600/20 rounded-lg transition-all group border border-gray-600/50 hover:border-blue-500/60">
                                <div class="w-10 h-10 bg-blue-500/20 group-hover:bg-blue-500/30 rounded-lg flex items-center justify-center mr-4 transition-colors">
                                    <svg class="w-5 h-5 text-blue-400" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M11.944 0A12 12 0 0 0 0 12a12 12 0 0 0 12 12a12 12 0 0 0 12-12A12 12 0 0 0 12 0a12 12 0 0 0-.056 0zm4.962 7.224c.1-.002.321.023.465.14a.506.506 0 0 1 .171.325c.016.093.036.306.02.472c-.18 1.898-.962 6.502-1.36 8.627c-.168.9-.499 1.201-.820 1.23c-.696.065-1.225-.46-1.9-.902c-1.056-.693-1.653-1.124-2.678-1.8c-1.185-.78-.417-1.21.258-1.91c.177-.184 3.247-2.977 3.307-3.23c.007-.032.014-.15-.056-.212s-.174-.041-.249-.024c-.106.024-1.793 1.14-5.061 3.345c-.48.33-.913.49-1.302.48c-.428-.008-1.252-.241-1.865-.44c-.752-.245-1.349-.374-1.297-.789c.027-.216.325-.437.893-.663c3.498-1.524 5.83-2.529 6.998-3.014c3.332-1.386 4.025-1.627 4.476-1.635z"/>
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-white font-semibold group-hover:text-blue-300 transition-colors">Telegram</p>
                                    <p class="text-xs text-dark-400">Get updates</p>
                                </div>
                            </a>
                            
                            <a href="{{ settings('youtube_link', '#') }}" target="_blank" class="flex items-center p-4 bg-gray-700/80 hover:bg-red-600/20 rounded-lg transition-all group border border-gray-600/50 hover:border-red-500/60">
                                <div class="w-10 h-10 bg-red-500/20 group-hover:bg-red-500/30 rounded-lg flex items-center justify-center mr-4 transition-colors">
                                    <svg class="w-5 h-5 text-red-400" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-white font-semibold group-hover:text-red-300 transition-colors">YouTube</p>
                                    <p class="text-xs text-dark-400">Watch videos</p>
                                </div>
                            </a>
                        </div>
                    </div>

                    <!-- Game Masters Widget -->
                    @if(isset($gms) && count($gms) > 0)
                        <div class="bg-gray-800/95 rounded-xl p-6 shadow-lg border border-gray-700/60">
                            <h3 class="text-lg font-bold text-white mb-6 flex items-center">
                                <i class="fas fa-shield-alt mr-3 text-primary-400"></i>
                                {{ trans('news.game_masters') }}
                            </h3>
                            <div class="space-y-3">
                                @foreach($gms as $gm)
                                    <div class="flex items-center justify-between p-3 bg-gray-700/60 rounded-lg border border-gray-600/40">
                                        <div class="flex items-center">
                                            <div class="w-8 h-8 bg-gradient-to-br from-primary-500/20 to-primary-600/30 rounded-full flex items-center justify-center mr-3">
                                                <i class="fas fa-user-shield text-primary-400 text-xs"></i>
                                            </div>
                                            <span class="text-white font-semibold">{{ $gm->name }}</span>
                                        </div>
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-semibold {{ $gm->online() ? 'bg-emerald-500/20 text-emerald-300' : 'bg-red-500/20 text-red-300' }}">
                                            <div class="w-2 h-2 {{ $gm->online() ? 'bg-emerald-400' : 'bg-red-400' }} rounded-full mr-1"></div>
                                            {{ $gm->online() ? trans('news.online') : trans('news.offline') }}
                                        </span>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
/* Enhanced News Content Styling */
.news-content {
    color: #f1f5f9;
    line-height: 1.8;
}

.news-content p {
    color: #e2e8f0;
    margin-bottom: 1.25rem;
    font-size: 1.05rem;
}

.news-content h1, .news-content h2, .news-content h3, .news-content h4, .news-content h5, .news-content h6 {
    color: #ffffff;
    font-weight: 700;
    margin-top: 2rem;
    margin-bottom: 1rem;
    line-height: 1.3;
}

.news-content h3 {
    color: #38bdf8;
    font-size: 1.25rem;
    border-bottom: 2px solid rgba(56, 189, 248, 0.2);
    padding-bottom: 0.5rem;
}

.news-content a {
    color: #38bdf8;
    text-decoration: none;
    border-bottom: 1px solid rgba(56, 189, 248, 0.3);
    transition: all 0.2s;
}

.news-content a:hover {
    color: #0ea5e9;
    border-bottom-color: #0ea5e9;
}

.news-content ul, .news-content ol {
    color: #e2e8f0;
    margin-left: 2rem;
    margin-bottom: 1.5rem;
    padding-left: 0.5rem;
}

.news-content li {
    color: #e2e8f0;
    margin-bottom: 0.75rem;
    position: relative;
    line-height: 1.6;
}

.news-content ul li::before {
    content: "▸";
    color: #38bdf8;
    font-weight: bold;
    position: absolute;
    left: -1.5rem;
    font-size: 1.1rem;
}

.news-content ol {
    counter-reset: item;
}

.news-content ol li {
    counter-increment: item;
}

.news-content ol li::before {
    content: counter(item) ".";
    color: #38bdf8;
    font-weight: bold;
    position: absolute;
    left: -2rem;
    font-size: 1rem;
}

.news-content blockquote {
    border-left: 4px solid #38bdf8;
    margin: 2rem 0;
    padding: 1.5rem 2rem;
    background: linear-gradient(135deg, rgba(56, 189, 248, 0.1) 0%, rgba(56, 189, 248, 0.05) 100%);
    border-radius: 0.75rem;
    position: relative;
    backdrop-filter: blur(10px);
}

.news-content blockquote::before {
    content: '"';
    font-size: 4rem;
    color: rgba(56, 189, 248, 0.3);
    position: absolute;
    top: -0.5rem;
    left: 1rem;
    font-family: serif;
}

.news-content blockquote p {
    color: #cbd5e1;
    font-style: italic;
    margin: 0;
    font-size: 1.1rem;
    position: relative;
    z-index: 1;
}

.news-content code {
    background: linear-gradient(135deg, #334155 0%, #1e293b 100%);
    color: #38bdf8;
    padding: 0.25rem 0.5rem;
    border-radius: 0.375rem;
    font-size: 0.9rem;
    font-family: 'Courier New', monospace;
    border: 1px solid #475569;
    font-weight: 500;
}

.news-content pre {
    background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
    color: #f1f5f9;
    padding: 1.5rem;
    border-radius: 0.75rem;
    overflow-x: auto;
    margin: 2rem 0;
    border: 1px solid #334155;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.news-content table {
    width: 100%;
    border-collapse: collapse;
    margin: 2rem 0;
    background: linear-gradient(135deg, rgba(51, 65, 85, 0.4) 0%, rgba(30, 41, 59, 0.4) 100%);
    border-radius: 0.75rem;
    overflow: hidden;
    backdrop-filter: blur(10px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.news-content th, .news-content td {
    border: 1px solid #475569;
    padding: 1rem 1.25rem;
    text-align: left;
    color: #e2e8f0;
}

.news-content th {
    background: linear-gradient(135deg, #334155 0%, #1e293b 100%);
    font-weight: 700;
    color: #ffffff;
    text-transform: uppercase;
    font-size: 0.875rem;
    letter-spacing: 0.05em;
}

.news-content tr:nth-child(even) {
    background-color: rgba(51, 65, 85, 0.2);
}

.news-content tr:hover {
    background-color: rgba(56, 189, 248, 0.05);
}

.news-content strong, .news-content b {
    color: #ffffff;
    font-weight: 700;
}

.news-content em, .news-content i {
    color: #cbd5e1;
}

.news-content img {
    max-width: 100%;
    height: auto;
    border-radius: 0.75rem;
    margin: 2rem 0;
    box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2);
}

.news-content .space-y-4 > * + * {
    margin-top: 1.5rem;
}

/* Smooth animations */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

article {
    animation: fadeInUp 0.6s ease-out;
}

article:nth-child(2) { animation-delay: 0.1s; }
article:nth-child(3) { animation-delay: 0.2s; }
article:nth-child(4) { animation-delay: 0.3s; }
</style>
@endpush