@extends('front.layouts.app')

@section('content')
    @include('front.ranking.nav')
    
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">{{ trans('ranking.faction') }} - {{ trans('ranking.type.' . Request::segment(3)) }}</h2>
        </div>
        <div class="card-body">
            @if($ranks->count() > 0)
                <div class="space-y-4">
                    @php $count = (($ranks->currentPage() - 1) * $ranks->perPage()) + 1 @endphp
                    @foreach($ranks as $rank)
                        <div class="bg-dark-50 rounded-xl p-4 hover:bg-dark-100/50 transition-all duration-200 hover:scale-[1.01] group">
                            <div class="flex items-center justify-between">
                                <!-- Rank & Faction Info -->
                                <div class="flex items-center space-x-4">
                                    <!-- Rank Number -->
                                    <div class="flex-shrink-0">
                                        @if($count <= 3)
                                            <div class="w-12 h-12 rounded-full flex items-center justify-center text-white font-bold text-lg
                                                {{ $count == 1 ? 'bg-gradient-to-br from-yellow-400 to-yellow-600' : '' }}
                                                {{ $count == 2 ? 'bg-gradient-to-br from-gray-300 to-gray-500' : '' }}
                                                {{ $count == 3 ? 'bg-gradient-to-br from-amber-600 to-amber-800' : '' }}">
                                                {{ $count }}
                                            </div>
                                        @else
                                            <div class="w-12 h-12 rounded-full bg-dark-200 flex items-center justify-center text-dark-600 font-bold">
                                                {{ $count }}
                                            </div>
                                        @endif
                                    </div>

                                    <!-- Faction Details -->
                                    <div class="flex-1 min-w-0">
                                        <div class="flex items-center space-x-3 mb-2">
                                            <div class="w-10 h-10 bg-gradient-to-br from-purple-500/20 to-pink-500/20 rounded-lg flex items-center justify-center">
                                                <svg class="w-5 h-5 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                                </svg>
                                            </div>
                                            <div>
                                                <h3 class="text-lg font-semibold text-dark-800 group-hover:text-primary-400 transition-colors">
                                                    {{ $rank->name }}
                                                </h3>
                                                <div class="flex items-center space-x-2 text-sm text-dark-500">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                                    </svg>
                                                    <span>{{ trans('ranking.leader') }}: {{ $rank->master_name }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Ranking Value -->
                                <div class="text-right">
                                    <div class="text-2xl font-bold text-primary-400">
                                        @if(Request::is('ranking/*/level'))
                                            {{ $rank->level }}
                                        @elseif(Request::is('ranking/*/members'))
                                            {{ number_format($rank->members) }}
                                        @elseif(Request::is('ranking/*/territories'))
                                            {{ number_format($rank->territories) }}
                                        @elseif(Request::is('ranking/*/pvp'))
                                            {{ number_format($rank->pk_count) }}
                                        @endif
                                    </div>
                                    <div class="text-xs text-dark-500 uppercase tracking-wide">
                                        {{ trans('ranking.type.' . Request::segment(3)) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        @php $count++ @endphp
                    @endforeach
                </div>

                <!-- Pagination -->
                @if($ranks->hasPages())
                    <div class="flex justify-center mt-8">
                        <nav class="flex items-center space-x-1">
                            {{-- Previous Page Link --}}
                            @if($ranks->onFirstPage())
                                <span class="px-3 py-2 text-sm text-dark-400 bg-dark-100 rounded-lg cursor-not-allowed">
                                    Previous
                                </span>
                            @else
                                <a href="{{ $ranks->previousPageUrl() }}" 
                                   class="px-3 py-2 text-sm text-dark-600 bg-dark-100 border border-dark-200 rounded-lg hover:bg-dark-200/50 transition-colors">
                                    Previous
                                </a>
                            @endif

                            {{-- Pagination Elements --}}
                            @foreach($ranks->getUrlRange(1, $ranks->lastPage()) as $page => $url)
                                @if($page == $ranks->currentPage())
                                    <span class="px-3 py-2 text-sm text-white bg-primary-500 rounded-lg">
                                        {{ $page }}
                                    </span>
                                @else
                                    <a href="{{ $url }}" 
                                       class="px-3 py-2 text-sm text-dark-600 bg-dark-100 border border-dark-200 rounded-lg hover:bg-dark-200/50 transition-colors">
                                        {{ $page }}
                                    </a>
                                @endif
                            @endforeach

                            {{-- Next Page Link --}}
                            @if($ranks->hasMorePages())
                                <a href="{{ $ranks->nextPageUrl() }}" 
                                   class="px-3 py-2 text-sm text-dark-600 bg-dark-100 border border-dark-200 rounded-lg hover:bg-dark-200/50 transition-colors">
                                    Next
                                </a>
                            @else
                                <span class="px-3 py-2 text-sm text-dark-400 bg-dark-100 rounded-lg cursor-not-allowed">
                                    Next
                                </span>
                            @endif
                        </nav>
                    </div>
                @endif
            @else
                <div class="text-center py-16">
                    <svg class="w-24 h-24 mx-auto text-dark-400 mb-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                    <h3 class="text-xl font-semibold text-dark-700 mb-2">No Faction Rankings Available</h3>
                    <p class="text-dark-500">There are no faction rankings to display at this time.</p>
                </div>
            @endif
        </div>
    </div>
@endsection