<div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
    <!-- Ranking Type Navigation -->
    <div class="card">
        <div class="card-body">
            <h3 class="text-sm font-medium text-dark-600 mb-4">Ranking Type</h3>
            <div class="flex flex-wrap gap-2">
                <a href="{{ url('ranking') }}" 
                   class="px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 {{ str_contains(Request::url(), 'player') ? 'bg-primary-500 text-white shadow-lg' : 'bg-dark-200/50 text-dark-600 hover:bg-dark-300/50 hover:text-dark-800' }}">
                    <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                    {{ trans('ranking.player') }}
                </a>
                <a href="{{ url('ranking/faction') }}" 
                   class="px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 {{ str_contains(Request::url(), 'faction') ? 'bg-primary-500 text-white shadow-lg' : 'bg-dark-200/50 text-dark-600 hover:bg-dark-300/50 hover:text-dark-800' }}">
                    <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                    {{ trans('ranking.faction') }}
                </a>
            </div>
        </div>
    </div>

    <!-- Ranking Category Navigation -->
    <div class="card">
        <div class="card-body">
            <h3 class="text-sm font-medium text-dark-600 mb-4">Category</h3>
            <div class="flex flex-wrap gap-2">
                @if(Route::is('ranking.player'))
                    <a href="{{ url('ranking/' . Request::segment(2) . '/level') }}" 
                       class="px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 {{ str_contains(Request::url(), 'level') ? 'bg-emerald-500 text-white shadow-lg' : 'bg-dark-200/50 text-dark-600 hover:bg-dark-300/50 hover:text-dark-800' }}">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                        {{ trans('ranking.type.level') }}
                    </a>
                    <a href="{{ url('ranking/' . Request::segment(2) . '/rep') }}" 
                       class="px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 {{ str_contains(Request::url(), 'rep') ? 'bg-emerald-500 text-white shadow-lg' : 'bg-dark-200/50 text-dark-600 hover:bg-dark-300/50 hover:text-dark-800' }}">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                        </svg>
                        {{ trans('ranking.type.rep') }}
                    </a>
                    <a href="{{ url('ranking/' . Request::segment(2) . '/time') }}" 
                       class="px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 {{ str_contains(Request::url(), 'time') ? 'bg-emerald-500 text-white shadow-lg' : 'bg-dark-200/50 text-dark-600 hover:bg-dark-300/50 hover:text-dark-800' }}">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        {{ trans('ranking.type.time') }}
                    </a>
                    <a href="{{ url('ranking/' . Request::segment(2) . '/pvp') }}" 
                       class="px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 {{ str_contains(Request::url(), 'pvp') ? 'bg-emerald-500 text-white shadow-lg' : 'bg-dark-200/50 text-dark-600 hover:bg-dark-300/50 hover:text-dark-800' }}">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                        </svg>
                        {{ trans('ranking.type.pvp') }}
                    </a>
                @endif
                
                @if(Route::is('ranking.faction'))
                    <a href="{{ url('ranking/' . Request::segment(2) . '/level') }}" 
                       class="px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 {{ str_contains(Request::url(), 'level') ? 'bg-emerald-500 text-white shadow-lg' : 'bg-dark-200/50 text-dark-600 hover:bg-dark-300/50 hover:text-dark-800' }}">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                        {{ trans('ranking.type.level') }}
                    </a>
                    <a href="{{ url('ranking/' . Request::segment(2) . '/members') }}" 
                       class="px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 {{ str_contains(Request::url(), 'members') ? 'bg-emerald-500 text-white shadow-lg' : 'bg-dark-200/50 text-dark-600 hover:bg-dark-300/50 hover:text-dark-800' }}">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                        {{ trans('ranking.type.members') }}
                    </a>
                    <a href="{{ url('ranking/' . Request::segment(2) . '/territories') }}" 
                       class="px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 {{ str_contains(Request::url(), 'territories') ? 'bg-emerald-500 text-white shadow-lg' : 'bg-dark-200/50 text-dark-600 hover:bg-dark-300/50 hover:text-dark-800' }}">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7"></path>
                        </svg>
                        {{ trans('ranking.type.territories') }}
                    </a>
                    <a href="{{ url('ranking/' . Request::segment(2) . '/pvp') }}" 
                       class="px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 {{ str_contains(Request::url(), 'pvp') ? 'bg-emerald-500 text-white shadow-lg' : 'bg-dark-200/50 text-dark-600 hover:bg-dark-300/50 hover:text-dark-800' }}">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                        </svg>
                        {{ trans('ranking.type.pvp') }}
                    </a>
                @endif
            </div>
        </div>
    </div>
</div>