@extends('front.layouts.app')

@section('content')
    @include('front.ranking.nav')
    
    <div class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60">
        <div class="p-6 border-b border-gray-700/40">
            <h2 class="text-xl font-bold text-white">{{ trans('ranking.player') }} - {{ trans('ranking.type.' . Request::segment(3)) }}</h2>
        </div>
        <div class="p-6">
            @if($ranks->count() > 0)
                <div class="space-y-4">
                    @php $count = (($ranks->currentPage() - 1) * $ranks->perPage()) + 1 @endphp
                    @foreach($ranks as $rank)
                        <div class="bg-gray-700/60 rounded-lg p-4 hover:bg-gray-600/70 transition-all duration-200 border border-gray-600/40 hover:border-gray-500/60 group">
                            <div class="flex items-center justify-between">
                                <!-- Rank & Player Info -->
                                <div class="flex items-center space-x-4">
                                    <!-- Rank Number -->
                                    <div class="flex-shrink-0">
                                        @if($count <= 3)
                                            <div class="w-12 h-12 rounded-full flex items-center justify-center text-white font-bold text-lg
                                                {{ $count == 1 ? 'bg-gradient-to-br from-yellow-400 to-yellow-600' : '' }}
                                                {{ $count == 2 ? 'bg-gradient-to-br from-gray-300 to-gray-500' : '' }}
                                                {{ $count == 3 ? 'bg-gradient-to-br from-amber-600 to-amber-800' : '' }}">
                                                {{ $count }}
                                            </div>
                                        @else
                                            <div class="w-12 h-12 rounded-full bg-dark-200 flex items-center justify-center text-dark-600 font-bold">
                                                {{ $count }}
                                            </div>
                                        @endif
                                    </div>

                                    <!-- Player Details -->
                                    <div class="flex-1 min-w-0">
                                        <div class="flex items-center space-x-3 mb-2">
                                            <h3 class="text-lg font-semibold text-dark-800 group-hover:text-primary-400 transition-colors">
                                                {{ $rank->name }}
                                            </h3>
                                            @if($rank->faction_name)
                                                <span class="px-2 py-1 bg-purple-500/20 text-purple-600 rounded-full text-xs font-medium">
                                                    {{ $rank->faction_name }}
                                                </span>
                                            @endif
                                        </div>
                                        
                                        <div class="flex flex-wrap items-center gap-4 text-sm text-dark-500">
                                            <!-- Class -->
                                            <div class="flex items-center space-x-2">
                                                <div class="w-4 h-4 bg-gradient-to-br from-primary-500/20 to-purple-500/20 rounded"></div>
                                                <span>{{ trans('main.classes.' . $rank->cls) }}</span>
                                            </div>
                                            
                                            <!-- Gender -->
                                            <div class="flex items-center space-x-2">
                                                <img src="/img/gender/{{ $rank->gender }}.png" class="w-4 h-4" alt="Gender">
                                                <span>{{ trans('ranking.gender.' . $rank->gender) }}</span>
                                            </div>
                                            
                                            <!-- Spouse -->
                                            <div class="flex items-center space-x-2">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                                                </svg>
                                                <span>
                                                    @if($rank->spouse)
                                                        @if(!$players->getSpouse($rank->spouse))
                                                            {{ trans('ranking.spouse.4everalone') }}
                                                        @else
                                                            {{ $players->getSpouse($rank->spouse)->name }}
                                                        @endif
                                                    @else
                                                        {{ trans('ranking.spouse.4everalone') }}
                                                    @endif
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Ranking Value -->
                                <div class="text-right">
                                    <div class="text-2xl font-bold text-primary-400">
                                        @if(Request::is('ranking/*/level'))
                                            {{ $rank->level }}
                                        @elseif(Request::is('ranking/*/rep'))
                                            {{ number_format($rank->reputation) }}
                                        @elseif(Request::is('ranking/*/time'))
                                            {{ makeTime($rank->time_used) }}
                                        @elseif(Request::is('ranking/*/pvp'))
                                            {{ $rank->pk_count }}
                                        @endif
                                    </div>
                                    <div class="text-xs text-dark-500 uppercase tracking-wide">
                                        {{ trans('ranking.type.' . Request::segment(3)) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        @php $count++ @endphp
                    @endforeach
                </div>

                <!-- Pagination -->
                @if($ranks->hasPages())
                    <div class="flex justify-center mt-8">
                        <nav class="flex items-center space-x-1">
                            {{-- Previous Page Link --}}
                            @if($ranks->onFirstPage())
                                <span class="px-3 py-2 text-sm text-dark-400 bg-dark-100 rounded-lg cursor-not-allowed">
                                    Previous
                                </span>
                            @else
                                <a href="{{ $ranks->previousPageUrl() }}" 
                                   class="px-3 py-2 text-sm text-dark-600 bg-dark-100 border border-dark-200 rounded-lg hover:bg-dark-200/50 transition-colors">
                                    Previous
                                </a>
                            @endif

                            {{-- Pagination Elements --}}
                            @foreach($ranks->getUrlRange(1, $ranks->lastPage()) as $page => $url)
                                @if($page == $ranks->currentPage())
                                    <span class="px-3 py-2 text-sm text-white bg-primary-500 rounded-lg">
                                        {{ $page }}
                                    </span>
                                @else
                                    <a href="{{ $url }}" 
                                       class="px-3 py-2 text-sm text-dark-600 bg-dark-100 border border-dark-200 rounded-lg hover:bg-dark-200/50 transition-colors">
                                        {{ $page }}
                                    </a>
                                @endif
                            @endforeach

                            {{-- Next Page Link --}}
                            @if($ranks->hasMorePages())
                                <a href="{{ $ranks->nextPageUrl() }}" 
                                   class="px-3 py-2 text-sm text-dark-600 bg-dark-100 border border-dark-200 rounded-lg hover:bg-dark-200/50 transition-colors">
                                    Next
                                </a>
                            @else
                                <span class="px-3 py-2 text-sm text-dark-400 bg-dark-100 rounded-lg cursor-not-allowed">
                                    Next
                                </span>
                            @endif
                        </nav>
                    </div>
                @endif
            @else
                <div class="text-center py-16">
                    <svg class="w-24 h-24 mx-auto text-dark-400 mb-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                    <h3 class="text-xl font-semibold text-dark-700 mb-2">No Rankings Available</h3>
                    <p class="text-dark-500">There are no player rankings to display at this time.</p>
                </div>
            @endif
        </div>
    </div>
@endsection