@extends('front.layouts.app')

@section('content')
    @include('front.ranking.nav')
    
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Territory War Map</h2>
            <p class="text-sm text-dark-500 mt-1">Interactive map showing faction territories and control</p>
        </div>
        <div class="card-body">
            <!-- Territory Map Container -->
            <div class="bg-dark-900 rounded-xl p-6 min-h-96 hidden md:block">
                <div id="map-container" class="w-full h-full flex items-center justify-center">
                    <object data="{{ asset('img/svg/PW-Territory.svg') }}" 
                            type="image/svg+xml" 
                            id="battlemap"
                            class="w-full h-full max-w-4xl max-h-96 rounded-lg">
                        <div class="text-center py-16">
                            <svg class="w-16 h-16 mx-auto text-dark-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7"></path>
                            </svg>
                            <p class="text-dark-500">Territory map could not be loaded</p>
                        </div>
                    </object>
                </div>
            </div>

            <!-- Mobile Notice -->
            <div class="md:hidden text-center py-16">
                <svg class="w-16 h-16 mx-auto text-dark-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                </svg>
                <h3 class="text-lg font-semibold text-dark-700 mb-2">Desktop Required</h3>
                <p class="text-dark-500">The territory map is best viewed on desktop devices for optimal interaction.</p>
            </div>

            <!-- Territory Info Panel -->
            <div class="mt-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                <div class="bg-dark-50 rounded-xl p-4">
                    <div class="text-sm text-dark-500 mb-1">Zone Level</div>
                    <div id="zone_level" class="text-lg font-semibold text-dark-800">-</div>
                </div>
                <div class="bg-dark-50 rounded-xl p-4">
                    <div class="text-sm text-dark-500 mb-1">Owner</div>
                    <div id="zone_owner" class="text-lg font-semibold text-dark-800">-</div>
                </div>
                <div class="bg-dark-50 rounded-xl p-4">
                    <div class="text-sm text-dark-500 mb-1">Challenger</div>
                    <div id="zone_challenger" class="text-lg font-semibold text-dark-800">-</div>
                </div>
                <div class="bg-dark-50 rounded-xl p-4">
                    <div class="text-sm text-dark-500 mb-1">Challenge Time</div>
                    <div id="zone_challenge_time" class="text-lg font-semibold text-dark-800">-</div>
                </div>
            </div>

            <!-- Legend -->
            <div class="mt-6 bg-dark-50 rounded-xl p-4">
                <h4 class="font-semibold text-dark-800 mb-3">Map Legend</h4>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-4 bg-blue-500 rounded"></div>
                        <span class="text-dark-600">Controlled Territory</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-4 bg-red-500 rounded"></div>
                        <span class="text-dark-600">Under Attack</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-4 bg-gray-300 rounded border-2 border-gray-400"></div>
                        <span class="text-dark-600">Neutral Territory</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const cities = {!! $zones !!};
    const battlemap = document.getElementById('battlemap');
    
    if (battlemap) {
        battlemap.addEventListener('load', function() {
            try {
                const mapDoc = battlemap.contentDocument || battlemap.contentWindow.document;
                const zones = mapDoc.querySelectorAll('path');
                
                zones.forEach(function(zone) {
                    const id = zone.id;
                    
                    if (cities[id]) {
                        const city = cities[id];
                        
                        // Set initial colors
                        if (city.owner > 0) {
                            zone.setAttribute('fill', `rgb(${city.color})`);
                            zone.setAttribute('opacity', '0.7');
                        } else {
                            zone.setAttribute('fill', 'rgb(255, 255, 255)');
                            zone.setAttribute('opacity', '0.1');
                        }
                        
                        // Add hover effects
                        zone.addEventListener('mouseover', function() {
                            zone.setAttribute('opacity', '0.9');
                            zone.style.cursor = 'pointer';
                            
                            // Update info panel
                            document.getElementById('zone_level').textContent = city.level || '-';
                            document.getElementById('zone_owner').textContent = city.owner_name || '-';
                            document.getElementById('zone_challenger').textContent = city.challenger_name || '-';
                            document.getElementById('zone_challenge_time').textContent = 
                                (city.challenger > 0) ? city.challenge_time : '-';
                        });
                        
                        zone.addEventListener('mouseout', function() {
                            if (city.owner > 0) {
                                zone.setAttribute('opacity', '0.7');
                            } else {
                                zone.setAttribute('opacity', '0.1');
                            }
                        });
                    }
                });
            } catch (error) {
                console.error('Error loading territory map:', error);
            }
        });
    }
});
</script>
@endpush