@extends('front.layouts.app')

@section('content')
    <div class="space-y-8">
        <div class="text-center">
            <h1 class="text-3xl font-bold gradient-text mb-4">Game Services</h1>
            <p class="text-dark-500 max-w-2xl mx-auto">
                Enhance your gaming experience with our premium services. Choose from a variety of options to boost your character and gameplay.
            </p>
            <!-- Debug Info -->
            <div class="mt-4 text-sm text-dark-600">
                Total Services: {{ $services->count() }} | 
                Enabled Services: {{ $services->where('enabled', true)->count() }}
            </div>
        </div>

        @if($services->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($services as $service)
                    @if($service->enabled ?? true)
                        <div class="bg-gray-800/95 rounded-xl overflow-hidden hover:bg-gray-700/95 transition-all duration-300 shadow-lg border border-gray-700/60 hover:border-gray-600/80 group">
                            <form action="{{ url('services/' . $service->key) }}" method="post">
                                {!! csrf_field() !!}
                                
                                <!-- Service Icon -->
                                <div class="p-6 text-center border-b border-gray-700/40">
                                    <div class="w-16 h-16 mx-auto mb-4 p-4 bg-gradient-to-br from-primary-500/20 to-purple-500/20 rounded-xl group-hover:scale-110 transition-transform duration-300">
                                        <svg class="w-full h-full text-primary-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                                        </svg>
                                    </div>
                                    <h3 class="text-xl font-semibold text-dark-800 group-hover:text-primary-400 transition-colors">
                                        {{ ucfirst(str_replace('_', ' ', $service->key)) }}
                                    </h3>
                                </div>

                                <div class="card-body">
                                    <!-- Price -->
                                    <div class="text-center mb-6">
                                        @if($service->price > 0)
                                            <div class="text-2xl font-bold text-primary-400">
                                                {{ number_format($service->price) }}
                                            </div>
                                            <div class="text-sm text-dark-500">
                                                {{ ($service->currency_type == 'virtual') ? settings('currency_name') : 'Gold' }}
                                            </div>
                                        @else
                                            <div class="text-2xl font-bold text-emerald-500">
                                                Free
                                            </div>
                                        @endif
                                    </div>

                                    <!-- Description -->
                                    <div class="bg-dark-50 rounded-lg p-4 mb-6">
                                        @if($service->key == 'broadcast')
                                            <p class="text-sm text-dark-600 font-medium">Send a message to all players currently online in the game world.</p>
                                        @elseif($service->key == 'virtual_to_cubi')
                                            <p class="text-sm text-dark-600 font-medium">Convert your virtual currency to in-game Cubi for purchases.</p>
                                        @elseif($service->key == 'cultivation_change')
                                            <p class="text-sm text-dark-600 font-medium">Switch between different cultivation paths for your character.</p>
                                        @elseif($service->key == 'gold_to_virtual')
                                            <p class="text-sm text-dark-600 font-medium">Exchange your in-game gold for virtual currency.</p>
                                        @else
                                            <p class="text-sm text-dark-600 font-medium">{{ ucfirst(str_replace('_', ' ', $service->key)) }} service for your character.</p>
                                        @endif
                                    </div>

                                    <!-- Action Button -->
                                    <!-- Dynamic Inputs -->
                                    @if($service->key == 'broadcast')
                                        <div class="mb-4">
                                            <label class="block text-sm text-dark-400 mb-1">{{ trans('services.fields.message') ?? 'Message' }}</label>
                                            <textarea name="message" required rows="3" class="w-full px-3 py-2 rounded bg-dark-900 text-dark-100 border border-gray-700/40"></textarea>
                                        </div>
                                    @elseif(in_array($service->key, ['virtual_to_cubi','gold_to_virtual','level_up']))
                                        <div class="mb-4">
                                            <label class="block text-sm text-dark-400 mb-1">{{ trans('services.fields.quantity') ?? 'Quantity' }}</label>
                                            <input type="number" name="quantity" min="1" value="1" required class="w-full px-3 py-2 rounded bg-dark-900 text-dark-100 border border-gray-700/40" />
                                        </div>
                                    @endif

                                    <button type="submit" class="btn btn-primary btn-block">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                                        </svg>
                                        Purchase Service
                                    </button>
                                </div>
                            </form>
                        </div>
                    @endif
                @endforeach
            </div>
        @else
            <div class="card text-center py-16">
                <div class="card-body">
                    <svg class="w-24 h-24 mx-auto text-dark-400 mb-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                    <h3 class="text-xl font-semibold text-dark-800 mb-2">No Services Available</h3>
                    <p class="text-dark-600">There are currently no services available. Please check back later.</p>
                </div>
            </div>
        @endif
    </div>
@endsection