@extends('front.layouts.app')

@section('content')
<div class="flex flex-col lg:flex-row gap-8">
    <!-- Sidebar -->
    <div class="lg:w-1/4">
        @include('front.shop.sidebar-tailwind')
    </div>

    <!-- Main Content -->
    <div class="lg:w-3/4">
        @if($items->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
                @foreach($items as $item)
                    <div class="card group hover:scale-105 transition-all duration-300 hover:shadow-2xl">
                        <form action="{{ url('shop/purchase/' . $item->id) }}" method="post">
                            {!! csrf_field() !!}
                            
                            <!-- Item Image -->
                            <div class="relative p-6 text-center">
                                <div class="w-16 h-16 mx-auto mb-4 p-3 bg-gradient-to-br from-primary-500/20 to-purple-500/20 rounded-xl">
                                    <img src="{{ asset(File::exists(base_path('public/img/icons/' . $item->item_id . '.gif')) ? 'img/icons/' . $item->item_id . '.gif' : 'img/icons/0.gif') }}" 
                                         alt="{{ $item->name }}" 
                                         class="w-full h-full object-contain">
                                </div>
                                
                                @if($item->discount)
                                    <div class="absolute top-4 right-4">
                                        <span class="bg-gradient-to-r from-red-500 to-pink-500 text-white text-xs font-bold px-2 py-1 rounded-full">
                                            -{{ $item->discount }}%
                                        </span>
                                    </div>
                                @endif
                            </div>

                            <!-- Item Info -->
                            <div class="px-6 pb-6">
                                <!-- Item Name -->
                                <h3 class="text-lg font-semibold text-dark-800 mb-3 text-center group-hover:text-primary-400 transition-colors">
                                    {{ $item->name }}
                                </h3>

                                <!-- Price -->
                                <div class="text-center mb-4">
                                    @if($item->discount)
                                        <div class="space-x-2">
                                            <span class="text-dark-400 line-through text-sm">{{ $item->price }}</span>
                                            <span class="text-primary-400 font-bold text-lg">
                                                {{ $item->price - (($item->price / 100) * $item->discount) }}
                                            </span>
                                            <span class="text-dark-500 text-sm">{{ settings('currency_name') }}</span>
                                        </div>
                                    @else
                                        <span class="text-primary-400 font-bold text-lg">{{ $item->price }}</span>
                                        <span class="text-dark-500 text-sm ml-1">{{ settings('currency_name') }}</span>
                                    @endif
                                </div>

                                <!-- Description -->
                                <div class="bg-dark-50 rounded-lg p-3 mb-4 max-h-24 overflow-y-auto">
                                    <div class="text-sm text-dark-600 prose prose-sm max-w-none">
                                        {!! $item->description !!}
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="flex gap-2">
                                    @if($item->shareable)
                                        <button type="button" 
                                                class="flex-1 btn bg-gradient-to-r from-purple-500 to-pink-500 text-white hover:from-purple-600 hover:to-pink-600" 
                                                onclick="openGiftModal('{{ $item->id }}', '{{ $item->name }}')">
                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                                            </svg>
                                            {{ trans('shop.gift') }}
                                        </button>
                                    @endif
                                    <button type="submit" class="flex-1 btn btn-success">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                                        </svg>
                                        {{ trans('shop.buy') }}
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                    <!-- Gift Modal -->
                    <div id="giftModal_{{ $item->id }}" class="fixed inset-0 bg-black/50 backdrop-blur-sm z-50 hidden items-center justify-center p-4">
                        <div class="card max-w-md w-full max-h-[90vh] overflow-y-auto">
                            <form method="post" action="{{ url('shop/gift/' . $item->id) }}">
                                {!! csrf_field() !!}
                                
                                <!-- Modal Header -->
                                <div class="card-header flex items-center justify-between">
                                    <h3 class="card-title">{{ trans('shop.gift_title', ['name' => $item->name]) }}</h3>
                                    <button type="button" onclick="closeGiftModal('{{ $item->id }}')" class="text-dark-400 hover:text-dark-600">
                                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                        </svg>
                                    </button>
                                </div>

                                <!-- Modal Body -->
                                <div class="card-body">
                                    @if(!Auth::user()->characterId())
                                        <div class="text-center py-8">
                                            <svg class="w-16 h-16 mx-auto text-red-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                                            </svg>
                                            <p class="text-red-400 font-medium">{{ trans('shop.select_char_first') }}</p>
                                        </div>
                                    @else
                                        @php $friends = $api->getRoleFriends(Auth::user()->characterId()) @endphp
                                        @if(!$friends)
                                            <div class="text-center py-8">
                                                <svg class="w-16 h-16 mx-auto text-dark-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                                </svg>
                                                <p class="text-dark-500">{{ trans('shop.no_friends') }}</p>
                                            </div>
                                        @else
                                            <div class="mb-4">
                                                <p class="text-primary-400 text-sm text-center mb-4">{{ trans('shop.recently_added_friends') }}</p>
                                                <div class="grid grid-cols-2 gap-3">
                                                    @foreach($friends as $friend)
                                                        @foreach($friend as $key => $value)
                                                            <label class="flex items-center p-3 bg-dark-50 rounded-lg hover:bg-dark-200/50 cursor-pointer transition-colors">
                                                                <input type="checkbox" name="friends[]" value="{{ $value['rid'] }}" class="mr-3 rounded border-dark-300 text-primary-500 focus:ring-primary-500">
                                                                <span class="text-dark-700 text-sm">{{ $value['name'] }}</span>
                                                            </label>
                                                        @endforeach
                                                    @endforeach
                                                </div>
                                            </div>
                                            
                                            <button type="submit" class="btn btn-primary btn-block">
                                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                                                </svg>
                                                {{ trans('shop.send_gift') }}
                                            </button>
                                        @endif
                                    @endif
                                </div>
                            </form>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            @if($items->hasPages())
                <div class="flex justify-center mt-8">
                    <nav class="flex items-center space-x-1">
                        {{-- Previous Page Link --}}
                        @if($items->onFirstPage())
                            <span class="px-3 py-2 text-sm text-dark-400 bg-dark-100 rounded-lg cursor-not-allowed">
                                Previous
                            </span>
                        @else
                            <a href="{{ $items->previousPageUrl() }}" 
                               class="px-3 py-2 text-sm text-dark-600 bg-dark-100 border border-dark-200 rounded-lg hover:bg-dark-200/50 transition-colors">
                                Previous
                            </a>
                        @endif

                        {{-- Pagination Elements --}}
                        @foreach($items->getUrlRange(1, $items->lastPage()) as $page => $url)
                            @if($page == $items->currentPage())
                                <span class="px-3 py-2 text-sm text-white bg-primary-500 rounded-lg">
                                    {{ $page }}
                                </span>
                            @else
                                <a href="{{ $url }}" 
                                   class="px-3 py-2 text-sm text-dark-600 bg-dark-100 border border-dark-200 rounded-lg hover:bg-dark-200/50 transition-colors">
                                    {{ $page }}
                                </a>
                            @endif
                        @endforeach

                        {{-- Next Page Link --}}
                        @if($items->hasMorePages())
                            <a href="{{ $items->nextPageUrl() }}" 
                               class="px-3 py-2 text-sm text-dark-600 bg-dark-100 border border-dark-200 rounded-lg hover:bg-dark-200/50 transition-colors">
                                Next
                            </a>
                        @else
                            <span class="px-3 py-2 text-sm text-dark-400 bg-dark-100 rounded-lg cursor-not-allowed">
                                Next
                            </span>
                        @endif
                    </nav>
                </div>
            @endif
        @else
            <div class="card text-center py-16">
                <div class="card-body">
                    <svg class="w-24 h-24 mx-auto text-dark-400 mb-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                    </svg>
                    <h3 class="text-xl font-semibold text-dark-700 mb-2">No Items Available</h3>
                    <p class="text-dark-500">{{ trans('main.no_results') }}</p>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
function openGiftModal(itemId, itemName) {
    document.getElementById('giftModal_' + itemId).classList.remove('hidden');
    document.getElementById('giftModal_' + itemId).classList.add('flex');
}

function closeGiftModal(itemId) {
    document.getElementById('giftModal_' + itemId).classList.add('hidden');
    document.getElementById('giftModal_' + itemId).classList.remove('flex');
}

// Close modal when clicking outside
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('fixed') && e.target.classList.contains('inset-0')) {
        e.target.classList.add('hidden');
        e.target.classList.remove('flex');
    }
});
</script>
@endpush