<!-- Shop Sidebar -->
<div class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60">
    <div class="p-6 border-b border-gray-700/40">
        <h3 class="text-lg font-bold text-white">Shop Categories</h3>
    </div>
    <div class="p-0">
        <nav class="space-y-1">
            <!-- All Items -->
            <a href="{{ url('shop/') }}" 
               class="flex items-center px-6 py-3 text-sm font-medium transition-colors {{ Request::is('shop') ? 'bg-primary-500/20 text-primary-400 border-r-2 border-primary-400' : 'text-dark-600 hover:bg-dark-200/50 hover:text-primary-400' }}">
                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                </svg>
                {{ trans('shop.all') }}
            </a>

            <!-- Consumables -->
            <a href="{{ url('shop/mask/1') }}" 
               class="flex items-center px-6 py-3 text-sm font-medium transition-colors {{ Request::is('shop/mask/1') ? 'bg-primary-500/20 text-primary-400 border-r-2 border-primary-400' : 'text-dark-600 hover:bg-dark-200/50 hover:text-primary-400' }}">
                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
                </svg>
                {{ trans('shop.masks.1') }}
            </a>

            <!-- Equipment -->
            <div x-data="{ open: {{ array_key_exists(Request::segment(3), trans('shop.masks.armor')) ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between px-6 py-3 text-sm font-medium transition-colors {{ array_key_exists(Request::segment(3), trans('shop.masks.armor')) ? 'bg-primary-500/20 text-primary-400' : 'text-dark-600 hover:bg-dark-200/50 hover:text-primary-400' }}">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.618 5.984A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                        </svg>
                        {{ trans('shop.equipment') }}
                    </div>
                    <svg class="w-4 h-4 transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                
                <div x-show="open" x-transition class="bg-dark-50 border-l-2 border-primary-500/20 ml-6">
                    <a href="{{ url('shop/mask/2') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/2') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.armor.2') }}
                    </a>
                    <a href="{{ url('shop/mask/256') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/256') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.armor.256') }}
                    </a>
                    <a href="{{ url('shop/mask/16') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/16') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.armor.16') }}
                    </a>
                    <a href="{{ url('shop/mask/8') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/8') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.armor.8') }}
                    </a>
                    <a href="{{ url('shop/mask/64') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/64') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.armor.64') }}
                    </a>
                    <a href="{{ url('shop/mask/128') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/128') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.armor.128') }}
                    </a>
                </div>
            </div>

            <!-- Fashion -->
            <div x-data="{ open: {{ array_key_exists(Request::segment(3), trans('shop.masks.fashion')) ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between px-6 py-3 text-sm font-medium transition-colors {{ array_key_exists(Request::segment(3), trans('shop.masks.fashion')) ? 'bg-primary-500/20 text-primary-400' : 'text-dark-600 hover:bg-dark-200/50 hover:text-primary-400' }}">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zM21 5a2 2 0 00-2-2h-4a2 2 0 00-2 2v12a4 4 0 004 4 4 4 0 004-4V5z"></path>
                        </svg>
                        {{ trans('shop.fashion') }}
                    </div>
                    <svg class="w-4 h-4 transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                
                <div x-show="open" x-transition class="bg-dark-50 border-l-2 border-primary-500/20 ml-6">
                    <a href="{{ url('shop/mask/65536') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/65536') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.fashion.65536') }}
                    </a>
                    <a href="{{ url('shop/mask/8192') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/8192') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.fashion.8192') }}
                    </a>
                    <a href="{{ url('shop/mask/16384') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/16384') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.fashion.16384') }}
                    </a>
                    <a href="{{ url('shop/mask/32768') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/32768') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.fashion.32768') }}
                    </a>
                </div>
            </div>

            <!-- Accessories -->
            <div x-data="{ open: {{ array_key_exists(Request::segment(3), trans('shop.masks.accessories')) ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between px-6 py-3 text-sm font-medium transition-colors {{ array_key_exists(Request::segment(3), trans('shop.masks.accessories')) ? 'bg-primary-500/20 text-primary-400' : 'text-dark-600 hover:bg-dark-200/50 hover:text-primary-400' }}">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4"></path>
                        </svg>
                        {{ trans('shop.accessories') }}
                    </div>
                    <svg class="w-4 h-4 transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                
                <div x-show="open" x-transition class="bg-dark-50 border-l-2 border-primary-500/20 ml-6">
                    <a href="{{ url('shop/mask/4') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/4') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.accessories.4') }}
                    </a>
                    <a href="{{ url('shop/mask/32') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/32') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.accessories.32') }}
                    </a>
                    <a href="{{ url('shop/mask/1536') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/1536') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.accessories.1536') }}
                    </a>
                </div>
            </div>

            <!-- Charms -->
            <div x-data="{ open: {{ array_key_exists(Request::segment(3), trans('shop.masks.charms')) ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between px-6 py-3 text-sm font-medium transition-colors {{ array_key_exists(Request::segment(3), trans('shop.masks.charms')) ? 'bg-primary-500/20 text-primary-400' : 'text-dark-600 hover:bg-dark-200/50 hover:text-primary-400' }}">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                        </svg>
                        {{ trans('shop.charms') }}
                    </div>
                    <svg class="w-4 h-4 transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                
                <div x-show="open" x-transition class="bg-dark-50 border-l-2 border-primary-500/20 ml-6">
                    <a href="{{ url('shop/mask/1048576') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/1048576') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.charms.1048576') }}
                    </a>
                    <a href="{{ url('shop/mask/2097152') }}" 
                       class="block px-6 py-2 text-sm transition-colors {{ Request::is('shop/mask/2097152') ? 'text-primary-400 bg-primary-500/10' : 'text-dark-500 hover:text-primary-400 hover:bg-dark-200/30' }}">
                        {{ trans('shop.masks.charms.2097152') }}
                    </a>
                </div>
            </div>

            <!-- Other Categories -->
            <a href="{{ url('shop/mask/262144') }}" 
               class="flex items-center px-6 py-3 text-sm font-medium transition-colors {{ Request::is('shop/mask/262144') ? 'bg-primary-500/20 text-primary-400 border-r-2 border-primary-400' : 'text-dark-600 hover:bg-dark-200/50 hover:text-primary-400' }}">
                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                </svg>
                {{ trans('shop.masks.262144') }}
            </a>

            <a href="{{ url('shop/mask/524288') }}" 
               class="flex items-center px-6 py-3 text-sm font-medium transition-colors {{ Request::is('shop/mask/524288') ? 'bg-primary-500/20 text-primary-400 border-r-2 border-primary-400' : 'text-dark-600 hover:bg-dark-200/50 hover:text-primary-400' }}">
                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                </svg>
                {{ trans('shop.masks.524288') }}
            </a>

            <a href="{{ url('shop/mask/4096') }}" 
               class="flex items-center px-6 py-3 text-sm font-medium transition-colors {{ Request::is('shop/mask/4096') ? 'bg-primary-500/20 text-primary-400 border-r-2 border-primary-400' : 'text-dark-600 hover:bg-dark-200/50 hover:text-primary-400' }}">
                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
                </svg>
                {{ trans('shop.masks.4096') }}
            </a>

            <a href="{{ url('shop/mask/0') }}" 
               class="flex items-center px-6 py-3 text-sm font-medium transition-colors {{ Request::is('shop/mask/0') ? 'bg-primary-500/20 text-primary-400 border-r-2 border-primary-400' : 'text-dark-600 hover:bg-dark-200/50 hover:text-primary-400' }}">
                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                </svg>
                {{ trans('shop.masks.0') }}
            </a>
        </nav>
    </div>
</div>