@extends('front.layouts.app')

@section('content')
    <div class="space-y-8">
        <div class="text-center">
            <h1 class="text-3xl font-bold gradient-text mb-4">Vote for Rewards</h1>
            <p class="text-dark-500 max-w-2xl mx-auto">
                Support our server by voting on top lists and earn exclusive rewards. Your votes help us grow the community!
            </p>
        </div>

        @if(count($sites) == 0)
            <div class="bg-gray-800/95 rounded-xl shadow-lg border border-gray-700/60 text-center py-16">
                <div class="p-8">
                    <svg class="w-24 h-24 mx-auto text-dark-400 mb-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                    </svg>
                    <h3 class="text-xl font-semibold text-dark-700 mb-2">No Vote Sites Available</h3>
                    <p class="text-dark-500">{{ trans('vote.no_sites') }}</p>
                </div>
            </div>
        @else
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($sites as $site)
                    <div class="bg-gray-800/95 rounded-xl overflow-hidden hover:bg-gray-700/95 transition-all duration-300 shadow-lg border border-gray-700/60 hover:border-gray-600/80 group relative">
                        @if($site->double_rewards)
                            <div class="absolute top-4 right-4 z-10">
                                <span class="bg-gradient-to-r from-yellow-400 to-orange-500 text-white text-xs font-bold px-3 py-1 rounded-full animate-pulse">
                                    {{ trans('vote.double_rewards') }}
                                </span>
                            </div>
                        @endif

                        <div class="card-header">
                            <div class="flex items-center space-x-3">
                                <div class="w-12 h-12 bg-gradient-to-br from-primary-500/20 to-purple-500/20 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                                    <svg class="w-6 h-6 text-primary-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-lg font-semibold text-dark-800 group-hover:text-primary-400 transition-colors">
                                        {{ $site->name }}
                                    </h3>
                                    <p class="text-sm text-dark-500">Vote Site</p>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            @if($vote_info[$site->id]['status'])
                                <form action="{{ url('vote/check/' . $site->id) }}" method="post">
                                    {!! csrf_field() !!}
                                    <button type="submit" class="btn btn-primary btn-block btn-lg group-hover:scale-105 transition-transform duration-200">
                                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                        </svg>
                                        {{ trans('vote.button', ['name' => $site->name]) }}
                                    </button>
                                </form>
                            @else
                                <div class="bg-dark-50 rounded-xl p-6 text-center">
                                    <svg class="w-12 h-12 mx-auto text-amber-500 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <p class="text-dark-600 font-medium mb-3">{{ trans('vote.cooldown') }}</p>
                                    <div class="countdown-timer text-primary-400 font-bold text-lg" data-countdown="{{ $vote_info[$site->id]['end_time'] }}">
                                        Loading...
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const countdownElements = document.querySelectorAll('[data-countdown]');
    
    countdownElements.forEach(function(element) {
        const endTime = parseInt(element.dataset.countdown);
        const targetTime = new Date().getTime() + (endTime * 1000);
        
        const timer = setInterval(function() {
            const now = new Date().getTime();
            const distance = targetTime - now;
            
            if (distance < 0) {
                clearInterval(timer);
                element.innerHTML = "{{ trans('vote.cooldown_done') }}";
                setTimeout(() => location.reload(), 1000);
                return;
            }
            
            const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((distance % (1000 * 60)) / 1000);
            
            element.innerHTML = `
                <div class="flex items-center justify-center space-x-2">
                    <div class="text-center">
                        <div class="text-xl font-bold">${hours.toString().padStart(2, '0')}</div>
                        <div class="text-xs text-dark-500">{{ trans('vote.time.hours') }}</div>
                    </div>
                    <div class="text-dark-400">:</div>
                    <div class="text-center">
                        <div class="text-xl font-bold">${minutes.toString().padStart(2, '0')}</div>
                        <div class="text-xs text-dark-500">{{ trans('vote.time.minutes') }}</div>
                    </div>
                    <div class="text-dark-400">:</div>
                    <div class="text-center">
                        <div class="text-xl font-bold">${seconds.toString().padStart(2, '0')}</div>
                        <div class="text-xs text-dark-500">{{ trans('vote.time.seconds') }}</div>
                    </div>
                </div>
            `;
        }, 1000);
    });
});
</script>
@endpush