@extends('front.layouts.app')

@section('content')
    <div class="max-w-2xl mx-auto">
        <div class="card text-center">
            <div class="card-body py-16">
                <!-- Success Icon -->
                <div class="w-24 h-24 mx-auto mb-6 bg-gradient-to-br from-emerald-500/20 to-green-500/20 rounded-full flex items-center justify-center">
                    <svg class="w-12 h-12 text-emerald-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                    </svg>
                </div>

                <!-- Success Message -->
                <h2 class="text-2xl font-bold text-dark-800 mb-4">{{ trans('vote.success.continue') }}</h2>
                <div class="text-dark-600 mb-8 max-w-md mx-auto">
                    {!! trans('vote.success.notice') !!}
                </div>

                <!-- Action Button -->
                <a target="_blank" 
                   href="{{ $site->link }}" 
                   class="btn btn-primary btn-lg inline-flex items-center hover:scale-105 transition-transform duration-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                    </svg>
                    {{ trans('vote.success.button') }}
                </a>

                <!-- Back Link -->
                <div class="mt-6">
                    <a href="{{ url('vote') }}" class="text-primary-400 hover:text-primary-300 text-sm font-medium transition-colors">
                        ← Back to Vote Page
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection