@extends('front.layouts.app')

@section('content')
    <div class="space-y-8">
        <div class="text-center">
            <h1 class="text-3xl font-bold gradient-text mb-4">Redeem Voucher</h1>
            <p class="text-dark-500 max-w-2xl mx-auto">
                Have a voucher code? Enter it below to claim your rewards and enhance your gaming experience.
            </p>
        </div>

        <!-- Redeem Form -->
        <div class="max-w-md mx-auto">
            <div class="card">
                <div class="card-header text-center">
                    <div class="w-16 h-16 mx-auto mb-4 bg-gradient-to-br from-emerald-500/20 to-green-500/20 rounded-xl flex items-center justify-center">
                        <svg class="w-8 h-8 text-emerald-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"></path>
                        </svg>
                    </div>
                    <h2 class="card-title">{{ trans('voucher.redeem_title') }}</h2>
                </div>
                
                <div class="card-body">
                    <form action="{{ url('voucher/redeem') }}" method="post" class="space-y-6">
                        {!! csrf_field() !!}
                        
                        <div>
                            <label for="code" class="form-label">{{ trans('voucher.code') }}</label>
                            <input name="code" 
                                   type="text" 
                                   class="form-input text-center font-mono text-lg tracking-wider" 
                                   id="code"
                                   placeholder="Enter voucher code"
                                   style="text-transform: uppercase;"
                                   required>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-block btn-lg">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"></path>
                            </svg>
                            {{ trans('voucher.redeem') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Voucher History -->
        @if(count($voucher_logs) > 0)
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                        </svg>
                        {{ trans('voucher.logs.title') }}
                    </h2>
                </div>
                <div class="card-body">
                    <div class="space-y-4">
                        @foreach($voucher_logs as $log)
                            <div class="bg-dark-50 rounded-xl p-4 hover:bg-dark-100/50 transition-colors">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center space-x-4">
                                        <div class="w-10 h-10 bg-gradient-to-br from-emerald-500/20 to-green-500/20 rounded-lg flex items-center justify-center">
                                            <svg class="w-5 h-5 text-emerald-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"></path>
                                            </svg>
                                        </div>
                                        <div>
                                            <div class="font-medium text-dark-800">{{ $log->voucher->item_name }}</div>
                                            <div class="text-sm text-dark-500">
                                                Code: <span class="font-mono">{{ $log->voucher->code }}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <div class="text-lg font-semibold text-primary-400">{{ $log->voucher->item_count }}x</div>
                                        <div class="text-xs text-dark-500">{{ $log->created_at->format('M d, Y g:i A') }}</div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const codeInput = document.getElementById('code');
    if (codeInput) {
        codeInput.addEventListener('input', function(e) {
            e.target.value = e.target.value.toUpperCase();
        });
    }
});
</script>
@endpush