@extends('front.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <!-- Breadcrumb -->
    <nav class="flex items-center space-x-2 text-sm text-gray-400 mb-8">
        <a href="{{ url('wiki') }}" class="hover:text-primary-400 transition-colors">{{ trans('wiki.wiki') }}</a>
        <i class="fas fa-chevron-right text-xs"></i>
        <a href="{{ url('wiki?category=' . $article->category) }}" class="hover:text-primary-400 transition-colors">
            {{ trans('wiki.category.' . $article->category) }}
        </a>
        <i class="fas fa-chevron-right text-xs"></i>
        <span class="text-gray-500">{{ $article->title }}</span>
    </nav>

    <!-- Article Header -->
    <header class="mb-8">
        <!-- Category Badge -->
        <div class="flex items-center justify-between mb-4">
            <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-primary-500/20 text-primary-300 border border-primary-500/30">
                {{ trans('wiki.category.' . $article->category) }}
            </span>
            <div class="flex items-center space-x-4 text-sm text-gray-500">
                <div class="flex items-center">
                    <i class="fas fa-eye mr-2"></i>
                    {{ number_format($article->views) }} {{ trans('wiki.views') }}
                </div>
                <div class="flex items-center">
                    <i class="fas fa-calendar mr-2"></i>
                    {{ $article->created_at->format('M d, Y') }}
                </div>
            </div>
        </div>

        <!-- Title -->
        <h1 class="text-4xl md:text-5xl font-bold text-white mb-6 leading-tight">
            {{ $article->title }}
        </h1>

        <!-- Meta Information -->
        <div class="flex flex-wrap items-center gap-6 text-sm text-gray-400 pb-6 border-b border-gray-700/40">
            <div class="flex items-center">
                <i class="fas fa-user mr-2"></i>
                <span>{{ trans('wiki.author') }}: {{ $article->author->name ?? 'Admin' }}</span>
            </div>
            <div class="flex items-center">
                <i class="fas fa-clock mr-2"></i>
                <span>{{ trans('wiki.published') }} {{ $article->created_at->diffForHumans() }}</span>
            </div>
            @if($article->updated_at != $article->created_at)
                <div class="flex items-center">
                    <i class="fas fa-edit mr-2"></i>
                    <span>{{ trans('wiki.updated') }} {{ $article->updated_at->diffForHumans() }}</span>
                </div>
            @endif
        </div>
    </header>

    <!-- Article Content -->
    <article class="prose prose-lg prose-invert max-w-none mb-12">
        <div class="wiki-content">
            {!! $article->content !!}
        </div>
    </article>

    <!-- Article Footer -->
    <footer class="border-t border-gray-700/40 pt-8">
        <!-- Helpful Section -->
        <div class="bg-gray-800/60 rounded-xl p-6 mb-8">
            <div class="text-center">
                <h3 class="text-lg font-semibold text-white mb-4">{{ trans('wiki.helpful') }}</h3>
                <div class="flex justify-center space-x-4">
                    <button class="flex items-center px-4 py-2 bg-green-600/20 text-green-400 rounded-lg hover:bg-green-600/30 transition-colors">
                        <i class="fas fa-thumbs-up mr-2"></i>
                        {{ trans('wiki.yes') }}
                    </button>
                    <button class="flex items-center px-4 py-2 bg-red-600/20 text-red-400 rounded-lg hover:bg-red-600/30 transition-colors">
                        <i class="fas fa-thumbs-down mr-2"></i>
                        {{ trans('wiki.no') }}
                    </button>
                </div>
            </div>
        </div>

        <!-- Share & Actions -->
        <div class="flex flex-wrap items-center justify-between gap-4 mb-8">
            <div class="flex items-center space-x-4">
                <button class="flex items-center px-4 py-2 bg-gray-700/60 text-gray-300 rounded-lg hover:bg-gray-600/80 hover:text-white transition-colors">
                    <i class="fas fa-share-alt mr-2"></i>
                    {{ trans('wiki.share_article') }}
                </button>
                @if(Auth::check() && Auth::user()->isAdmin())
                    <a href="{{ url('admin/wiki/edit/' . $article->id) }}" 
                       class="flex items-center px-4 py-2 bg-primary-600/20 text-primary-400 rounded-lg hover:bg-primary-600/30 transition-colors">
                        <i class="fas fa-edit mr-2"></i>
                        {{ trans('wiki.edit_this_page') }}
                    </a>
                @endif
            </div>
            <a href="{{ url('wiki') }}" 
               class="flex items-center px-4 py-2 bg-gray-700/60 text-gray-300 rounded-lg hover:bg-gray-600/80 hover:text-white transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                {{ trans('wiki.back_to_wiki') }}
            </a>
        </div>
    </footer>

    <!-- Related Articles -->
    @if($relatedArticles->count() > 0)
        <section class="border-t border-gray-700/40 pt-12">
            <h2 class="text-2xl font-bold text-white mb-8">{{ trans('wiki.related_articles') }}</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($relatedArticles as $related)
                    <article class="bg-gray-800/60 rounded-xl p-6 hover:bg-gray-700/80 transition-all duration-300 border border-gray-700/40 hover:border-gray-600/60">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-xs font-medium text-primary-400 bg-primary-500/20 px-2 py-1 rounded">
                                {{ trans('wiki.category.' . $related->category) }}
                            </span>
                            <div class="flex items-center text-xs text-gray-500">
                                <i class="fas fa-eye mr-1"></i>
                                {{ number_format($related->views) }}
                            </div>
                        </div>
                        <h3 class="text-lg font-semibold text-white mb-2 line-clamp-2">
                            <a href="{{ url('wiki/' . $related->slug) }}" class="hover:text-primary-300 transition-colors">
                                {{ $related->title }}
                            </a>
                        </h3>
                        <p class="text-gray-400 text-sm line-clamp-2 mb-3">
                            {{ $related->excerpt }}
                        </p>
                        <div class="flex items-center justify-between text-xs text-gray-500">
                            <span>{{ $related->created_at->format('M d, Y') }}</span>
                            <a href="{{ url('wiki/' . $related->slug) }}" class="text-primary-400 hover:text-primary-300 transition-colors">
                                {{ trans('wiki.read_more') }} →
                            </a>
                        </div>
                    </article>
                @endforeach
            </div>
        </section>
    @endif
</div>

@push('styles')
<style>
/* Wiki Content Styling */
.wiki-content {
    color: #f1f5f9;
    line-height: 1.8;
}

.wiki-content p {
    color: #e2e8f0;
    margin-bottom: 1.5rem;
    font-size: 1.1rem;
}

.wiki-content h1, .wiki-content h2, .wiki-content h3, .wiki-content h4, .wiki-content h5, .wiki-content h6 {
    color: #ffffff;
    font-weight: 700;
    margin-top: 2.5rem;
    margin-bottom: 1.5rem;
    line-height: 1.3;
}

.wiki-content h2 {
    font-size: 1.875rem;
    border-bottom: 2px solid rgba(56, 189, 248, 0.2);
    padding-bottom: 0.75rem;
}

.wiki-content h3 {
    color: #38bdf8;
    font-size: 1.5rem;
}

.wiki-content h4 {
    font-size: 1.25rem;
    color: #94a3b8;
}

.wiki-content a {
    color: #38bdf8;
    text-decoration: none;
    border-bottom: 1px solid rgba(56, 189, 248, 0.3);
    transition: all 0.2s;
}

.wiki-content a:hover {
    color: #0ea5e9;
    border-bottom-color: #0ea5e9;
}

.wiki-content ul, .wiki-content ol {
    color: #e2e8f0;
    margin-left: 2rem;
    margin-bottom: 1.5rem;
    padding-left: 0.5rem;
}

.wiki-content li {
    color: #e2e8f0;
    margin-bottom: 0.75rem;
    position: relative;
    line-height: 1.7;
}

.wiki-content ul li::before {
    content: "▸";
    color: #38bdf8;
    font-weight: bold;
    position: absolute;
    left: -1.5rem;
    font-size: 1.1rem;
}

.wiki-content ol {
    counter-reset: item;
}

.wiki-content ol li {
    counter-increment: item;
}

.wiki-content ol li::before {
    content: counter(item) ".";
    color: #38bdf8;
    font-weight: bold;
    position: absolute;
    left: -2rem;
    font-size: 1rem;
}

.wiki-content blockquote {
    border-left: 4px solid #38bdf8;
    margin: 2rem 0;
    padding: 1.5rem 2rem;
    background: linear-gradient(135deg, rgba(56, 189, 248, 0.1) 0%, rgba(56, 189, 248, 0.05) 100%);
    border-radius: 0.75rem;
    position: relative;
    backdrop-filter: blur(10px);
}

.wiki-content blockquote p {
    color: #cbd5e1;
    font-style: italic;
    margin: 0;
    font-size: 1.1rem;
}

.wiki-content code {
    background: linear-gradient(135deg, #334155 0%, #1e293b 100%);
    color: #38bdf8;
    padding: 0.25rem 0.5rem;
    border-radius: 0.375rem;
    font-size: 0.9rem;
    font-family: 'Courier New', monospace;
    border: 1px solid #475569;
    font-weight: 500;
}

.wiki-content pre {
    background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
    color: #f1f5f9;
    padding: 1.5rem;
    border-radius: 0.75rem;
    overflow-x: auto;
    margin: 2rem 0;
    border: 1px solid #334155;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.wiki-content table {
    width: 100%;
    border-collapse: collapse;
    margin: 2rem 0;
    background: linear-gradient(135deg, rgba(51, 65, 85, 0.4) 0%, rgba(30, 41, 59, 0.4) 100%);
    border-radius: 0.75rem;
    overflow: hidden;
    backdrop-filter: blur(10px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.wiki-content th, .wiki-content td {
    border: 1px solid #475569;
    padding: 1rem 1.25rem;
    text-align: left;
    color: #e2e8f0;
}

.wiki-content th {
    background: linear-gradient(135deg, #334155 0%, #1e293b 100%);
    font-weight: 700;
    color: #ffffff;
    text-transform: uppercase;
    font-size: 0.875rem;
    letter-spacing: 0.05em;
}

.wiki-content tr:nth-child(even) {
    background-color: rgba(51, 65, 85, 0.2);
}

.wiki-content tr:hover {
    background-color: rgba(56, 189, 248, 0.05);
}

.wiki-content img {
    max-width: 100%;
    height: auto;
    border-radius: 0.75rem;
    margin: 2rem 0;
    box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2);
}

.line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}
</style>
@endpush
@endsection