@extends('front.layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <!-- Hero Section -->
    <div class="text-center mb-12">
        <div class="inline-flex items-center px-4 py-2 rounded-full bg-primary-500/10 border border-primary-500/20 text-primary-300 text-sm font-medium mb-6">
            <i class="fas fa-book mr-2"></i>
            {{ trans('wiki.knowledge_base') }}
        </div>
        <h1 class="text-5xl md:text-6xl font-bold mb-6">
            <span class="bg-gradient-to-r from-primary-400 via-primary-300 to-blue-400 bg-clip-text text-transparent">
                {{ trans('wiki.wiki') }}
            </span>
        </h1>
        <p class="text-xl text-dark-300 max-w-3xl mx-auto leading-relaxed">
            {{ trans('wiki.wiki_description') }}
        </p>
    </div>

    <!-- Search Bar -->
    <div class="max-w-2xl mx-auto mb-12">
        <form method="GET" action="{{ url('wiki') }}" class="relative">
            <div class="relative">
                <input type="text" 
                       name="search" 
                       value="{{ $search }}"
                       placeholder="{{ trans('wiki.search') }}"
                       class="w-full px-6 py-4 bg-gray-800/95 border border-gray-700/60 rounded-xl text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-transparent pr-12">
                <button type="submit" class="absolute right-4 top-1/2 transform -translate-y-1/2 text-gray-400 hover:text-primary-400 transition-colors">
                    <i class="fas fa-search"></i>
                </button>
            </div>
            @if($category)
                <input type="hidden" name="category" value="{{ $category }}">
            @endif
        </form>
    </div>

    <!-- Categories Filter -->
    <div class="mb-8">
        <div class="flex flex-wrap justify-center gap-3">
            <a href="{{ url('wiki') }}" 
               class="px-4 py-2 rounded-lg text-sm font-medium transition-all {{ !$category ? 'bg-primary-500 text-white' : 'bg-gray-800/60 text-gray-300 hover:bg-gray-700/80 hover:text-white' }}">
                {{ trans('wiki.all_categories') }}
            </a>
            @foreach($categories as $key => $name)
                <a href="{{ url('wiki?category=' . $key) }}" 
                   class="px-4 py-2 rounded-lg text-sm font-medium transition-all {{ $category == $key ? 'bg-primary-500 text-white' : 'bg-gray-800/60 text-gray-300 hover:bg-gray-700/80 hover:text-white' }}">
                    {{ trans('wiki.category.' . $key) }}
                    @if(isset($categoryCounts[$key]) && $categoryCounts[$key] > 0)
                        <span class="ml-1 text-xs opacity-75">({{ $categoryCounts[$key] }})</span>
                    @endif
                </a>
            @endforeach
        </div>
    </div>

    <!-- Search Results Header -->
    @if($search)
        <div class="mb-8">
            <h2 class="text-2xl font-bold text-white mb-2">{{ trans('wiki.search_results') }}</h2>
            <p class="text-gray-400">{{ $articles->total() }} {{ trans('wiki.articles') }} found for "{{ $search }}"</p>
        </div>
    @endif

    <!-- Articles Grid -->
    @if($articles->count() > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
            @foreach($articles as $article)
                <article class="bg-gray-800/95 rounded-xl overflow-hidden hover:bg-gray-700/95 transition-all duration-300 shadow-lg border border-gray-700/60 hover:border-gray-600/80 group">
                    <div class="p-6">
                        <!-- Category Badge -->
                        <div class="flex items-center justify-between mb-4">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-primary-500/20 text-primary-300">
                                {{ trans('wiki.category.' . $article->category) }}
                            </span>
                            <div class="flex items-center text-xs text-gray-500">
                                <i class="fas fa-eye mr-1"></i>
                                {{ number_format($article->views) }}
                            </div>
                        </div>

                        <!-- Title -->
                        <h3 class="text-xl font-semibold text-white mb-3 group-hover:text-primary-300 transition-colors line-clamp-2">
                            <a href="{{ url('wiki/' . $article->slug) }}">
                                {{ $article->title }}
                            </a>
                        </h3>

                        <!-- Excerpt -->
                        <p class="text-gray-400 mb-4 line-clamp-3">
                            {{ $article->excerpt }}
                        </p>

                        <!-- Meta -->
                        <div class="flex items-center justify-between text-sm text-gray-500">
                            <div class="flex items-center">
                                <i class="fas fa-calendar mr-2"></i>
                                {{ $article->created_at->format('M d, Y') }}
                            </div>
                            <a href="{{ url('wiki/' . $article->slug) }}" 
                               class="text-primary-400 hover:text-primary-300 font-medium transition-colors">
                                {{ trans('wiki.read_more') }} →
                            </a>
                        </div>
                    </div>
                </article>
            @endforeach
        </div>

        <!-- Pagination -->
        @if($articles->hasPages())
            <div class="flex justify-center">
                <nav class="flex items-center space-x-2">
                    {{-- Previous Page Link --}}
                    @if($articles->onFirstPage())
                        <span class="px-6 py-3 text-sm text-gray-500 bg-gray-800/80 rounded-lg cursor-not-allowed border border-gray-700/50">
                            <i class="fas fa-chevron-left mr-2"></i>{{ trans('news.previous') }}
                        </span>
                    @else
                        <a href="{{ $articles->previousPageUrl() }}" 
                           class="px-6 py-3 text-sm text-gray-300 bg-gray-800/80 rounded-lg hover:bg-gray-700/90 hover:text-primary-300 transition-all border border-gray-700/50 hover:border-primary-500/60">
                            <i class="fas fa-chevron-left mr-2"></i>{{ trans('news.previous') }}
                        </a>
                    @endif

                    {{-- Page Numbers --}}
                    @foreach($articles->getUrlRange(1, $articles->lastPage()) as $page => $url)
                        @if($page == $articles->currentPage())
                            <span class="px-4 py-3 text-sm text-white bg-primary-600 rounded-lg font-semibold border border-primary-500/60">
                                {{ $page }}
                            </span>
                        @else
                            <a href="{{ $url }}" 
                               class="px-4 py-3 text-sm text-gray-300 bg-gray-800/80 rounded-lg hover:bg-gray-700/90 hover:text-primary-300 transition-all border border-gray-700/50 hover:border-primary-500/60">
                                {{ $page }}
                            </a>
                        @endif
                    @endforeach

                    {{-- Next Page Link --}}
                    @if($articles->hasMorePages())
                        <a href="{{ $articles->nextPageUrl() }}" 
                           class="px-6 py-3 text-sm text-gray-300 bg-gray-800/80 rounded-lg hover:bg-gray-700/90 hover:text-primary-300 transition-all border border-gray-700/50 hover:border-primary-500/60">
                            {{ trans('news.next') }}<i class="fas fa-chevron-right ml-2"></i>
                        </a>
                    @else
                        <span class="px-6 py-3 text-sm text-gray-500 bg-gray-800/80 rounded-lg cursor-not-allowed border border-gray-700/50">
                            {{ trans('news.next') }}<i class="fas fa-chevron-right ml-2"></i>
                        </span>
                    @endif
                </nav>
            </div>
        @endif
    @else
        <!-- No Results -->
        <div class="text-center py-20">
            <div class="bg-gray-800/95 rounded-xl p-16 max-w-md mx-auto shadow-lg border border-gray-700/60">
                <div class="w-24 h-24 mx-auto mb-8 bg-gradient-to-br from-primary-500/20 to-primary-600/30 rounded-full flex items-center justify-center">
                    <i class="fas fa-search text-4xl text-primary-400"></i>
                </div>
                <h3 class="text-2xl font-bold text-white mb-4">{{ trans('wiki.no_results') }}</h3>
                <p class="text-dark-400 leading-relaxed">
                    {{ trans('wiki.no_results_description') }}
                </p>
            </div>
        </div>
    @endif
</div>

@push('styles')
<style>
.line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.line-clamp-3 {
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
}
</style>
@endpush
@endsection