<?php
/**
 * Simple script to switch back to Bootstrap views
 * Run: php switch-to-bootstrap.php
 */

echo "🔙 Switching back to Bootstrap views...\n\n";

// Restore original Bootstrap files
$restores = [
    'resources/views/front/header-bootstrap.blade.php' => 'resources/views/front/header.blade.php',
    'resources/views/front/footer-bootstrap.blade.php' => 'resources/views/front/footer.blade.php',
    'resources/views/front/widgets-bootstrap.blade.php' => 'resources/views/front/widgets.blade.php',
    'resources/views/front/donate/index-bootstrap.blade.php' => 'resources/views/front/donate/index.blade.php',
    'resources/views/front/news/index-bootstrap.blade.php' => 'resources/views/front/news/index.blade.php',
];

echo "🔄 Restoring Bootstrap views...\n";
foreach ($restores as $backup => $target) {
    if (file_exists($backup)) {
        copy($backup, $target);
        echo "✅ Restored: $target\n";
    } else {
        echo "❌ Backup not found: $backup\n";
    }
}

echo "\n🎉 Switch back to Bootstrap completed!\n";
echo "🌐 Visit your site to see the original Bootstrap design!\n\n";

echo "To switch to Tailwind again, run: php switch-to-tailwind.php\n";
?>