<?php
/**
 * Simple script to switch between Bootstrap and Tailwind views
 * Run: php switch-to-tailwind.php
 */

echo "🎨 Switching to Tailwind CSS views...\n\n";

// Backup original files
$backups = [
    'resources/views/front/header.blade.php' => 'resources/views/front/header-bootstrap.blade.php',
    'resources/views/front/footer.blade.php' => 'resources/views/front/footer-bootstrap.blade.php',
    'resources/views/front/widgets.blade.php' => 'resources/views/front/widgets-bootstrap.blade.php',
    'resources/views/front/donate/index.blade.php' => 'resources/views/front/donate/index-bootstrap.blade.php',
    'resources/views/front/news/index.blade.php' => 'resources/views/front/news/index-bootstrap.blade.php',
];

echo "📦 Creating backups...\n";
foreach ($backups as $original => $backup) {
    if (file_exists($original) && !file_exists($backup)) {
        copy($original, $backup);
        echo "✅ Backed up: $original → $backup\n";
    }
}

// Switch to Tailwind views
$switches = [
    'resources/views/front/layouts/app.blade.php' => 'resources/views/front/header.blade.php',
    'resources/views/front/layouts/footer.blade.php' => 'resources/views/front/footer.blade.php',
    'resources/views/front/layouts/widgets.blade.php' => 'resources/views/front/widgets.blade.php',
    'resources/views/front/donate/index-tailwind.blade.php' => 'resources/views/front/donate/index.blade.php',
    'resources/views/front/news/index-tailwind.blade.php' => 'resources/views/front/news/index.blade.php',
];

echo "\n🔄 Switching to Tailwind views...\n";
foreach ($switches as $source => $target) {
    if (file_exists($source)) {
        copy($source, $target);
        echo "✅ Switched: $target\n";
    } else {
        echo "❌ Source not found: $source\n";
    }
}

echo "\n🎉 Switch to Tailwind CSS completed!\n";
echo "📝 Your original Bootstrap files are backed up with '-bootstrap' suffix\n";
echo "🚀 Run 'npm run build' to compile assets if you haven't already\n";
echo "🌐 Visit your site to see the new Tailwind design!\n\n";

echo "To switch back to Bootstrap, run: php switch-to-bootstrap.php\n";
?>